clear all;
close all;

nmc = neural_microcircuit;
dt = 1e-3;
Tstim = 1;
time = (0:dt:Tstim);

[nmc, pin] = add(nmc, 'Pool', 'origin', [0 0 0], 'size', ...
                     [1 1 1], 'type', 'AnalogInputNeuron', ...
                     'frac_EXC', 1.0);
% Create the liquid
[nmc, poolnmc] = add(nmc, 'Pool', 'origin', [3 0 0], 'size', [1 1 1], ...
                     'frac_EXC', 1);


% Connect the input neurons to the liquid
[nmc, cip1] = add(nmc, 'Conn', 'src', pin, 'dest', poolnmc, 'type', 'StaticAnalogSynapse', ...
              'Cscale', Inf, 'lambda', Inf);

[pre, post] = csim('get', cip1, 'connections');
csim('set', pre, 'W', 1);

% now add recorders
nmc = record(nmc, 'Pool', poolnmc, 'Field', 'spikes','dt',dt);
nmc = record(nmc, 'Pool', poolnmc, 'Field', 'Vm','dt',dt);


I = 1e-5*logspace(-4, 0, 10);
for i = 1:length(I)
    S.channel(1).data = 0;
    S.channel(1).dt   = dt;
    S.channel(1).spiking = 0;
    sumrate = 0;
    for j = 1:50
        R = simulate(nmc, Tstim, S);
        sumrate = sumrate +  length(R{1}.channel(1).data);
    end
    avg_rate(i) = sumrate/50;
end;

plot(I, avg_rate);
