function op = space_code(ip, nChannels, kernelSize)
%-------------------------------------------------------------------------
% Desc - This file takes an analog input signal and converts this single
%        channel input into an nChannels input using the spatial coding
%        technicqe used in #151 and #158 (converting by spreading the IP
%        using a kernelSize wide gaussian kernel with the kernel centered
%        on a location proportional to input magnitude.
%
% Example -
%         IP dimension (1, 200), nChannels = 50;
%         OP dimension (
%
%        (c), 2005, Prashant Joshi
%-------------------------------------------------------------------------

center = get_center(ip, nChannels);

gaussKernel = gausswin(kernelSize);
gaussKernelNormalized = (gaussKernel - min(gaussKernel)) ./ (max(gaussKernel) - min(gaussKernel));

op = [];
for opIdx = 1:length(ip)
    ipDist = gaussKernelNormalized * ip(opIdx);
    opColumn = zeros(1, nChannels);
    winSize = (kernelSize -1) /2;
    ltIdx = center(opIdx) - winSize;
    rtIdx = center(opIdx) + winSize;
    count = 1;
    for j = ltIdx : rtIdx
        if(j > 1 & j <= nChannels)
           opColumn(j) = ipDist(count);
           count = count+1;
        else
            count = count+1;
        end
    end
    op = [op opColumn'];
end;

function center = get_center(ip, nChannels)
%-------------------------------------------------------------------------
% Desc - This function computes the center of gaussian kernel at each time
%        step.
%-------------------------------------------------------------------------
minVal = min(ip);
maxVal = max(ip);

% convert from [minVal, maxVal] to [1, nChannels]
ipNorm = (ip - minVal) ./ (maxVal - minVal);
center = round((nChannels -1) * ipNorm) + 1;
