function y = sig_curve(start, stop, nPoints)
%-------------------------------------------------------------------------
% Desc - Creates a sigmoid curve that connects the points start, stop
%        using nPoints number of points.
%-------------------------------------------------------------------------
  y = [];
  if(start <= stop)
      x = linspace(-5, 5, nPoints);
      y = start + (stop-start) * logsig(x);
  else
      x = linspace(5, -5, nPoints);
      y = stop + (start-stop) * logsig(x);
  end

