function [freq] = make_histogram(R, nBins, showPlot)
%-------------------------------------------------------------------------
% Desc - This function makes a histogram from the response of the neural
%        circuit.
%
%        (c), 2004, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------

numNeurons = size(R{1}.channel, 2);
tStim      = R{1}.Tsim;

for i = 1:numNeurons
    nSpikes = length(R{1}.channel(i).data);
    freq(i)    = nSpikes / tStim;
end
if(showPlot == 1)
    hist(freq, nBins);
end
