function [bin, data] = get_cross_correlogram(stA, stB, binSize, winSize, startTime)

if(nargin <2), error('Must supply atleast the base spike train and the second spike train.');end;
if(nargin <3), binSize = 1e-3;end;
if(nargin <4), winSize = 100e-3;end;
if(nargin <5), startTime = 0;end;

bin = (-winSize:binSize:winSize);
nBins = length(bin);
data = zeros(1, nBins);

stA(stA < startTime) = [];
stB(stB < startTime) = [];

for j = 1:length(stA)
    diffTime = stB - stA(j);
    diffTime(diffTime < (-1*winSize)) = [];
    diffTime(diffTime >winSize) = [];
    for k = 1:length(diffTime)
        idxBin = round(diffTime(k)/binSize)+ceil(winSize/binSize)+1;
        if(~isempty(idxBin))
            idxBin = idxBin(1);
            data(idxBin) = data(idxBin) + 1;
        end
    end
end 
