function spktrn = generate_poisson_spikes(discrete_function, rateup, ...
                                          ratedown, dt, Tstim, loval, hival)

%-------------------------------------------------------------------------
% Desc - This function generates poisson spike train with rate 'rateup'
%        when the discrete function is in up state and generates 
%        poisson spike train with rate 'ratedown' when the discrete
%        function is in down state.
%
%        (c), 2004, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------
spktrn = [];
t = (0:dt:Tstim);
transit_points = find_transition_points(discrete_function);

flag = 1;
flag(discrete_function(1) == loval) =0;

init_pos = 1;

for i = 1:length(transit_points)
    tmp_time = t(init_pos:transit_points(i));
    tot_time = length(tmp_time)*dt;
    if(flag == 0)
       rate = ratedown;
    else
       rate = rateup;
    end
    nSpikes = round(rate*tot_time);
    idx = randperm(length(tmp_time));
    idx = idx(1:nSpikes);
    spktrn = [spktrn tmp_time(idx)];
    init_pos = transit_points(i);
    flag = ~flag;
end
