function transit_points = find_transition_points(V)

%-------------------------------------------------------------------------
% Desc - This function calculates the transition points in a vector V. The
%        vector V can have two possible states. The function returns a 
%        array which holds the indexes of transitions.
%
%        (c), 2004, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------
minval = min(V);
maxval = max(V);

V(V==minval) = 0;
V(V==maxval) = 1;

d = diff(V);

transit_points = find(d);
