function [center, distOP] = distributeIP(input, spread, centerIn)

%-------------------------------------------------------------------------
% Desc - This function takes the Input signal which is of type 1 X N and 
%         spreads it into  a M X N signal, where M is the value of IP Spread. 
%         This spread is based on a Gaussian function.
%
%         The equation of the Gaussian is:
%
%         y = f(x) = (1/ (sigma * sqrt(2*pi))) * exp(-1*((x - mu)^2))/(2*sigma^2))
%
% Signature	- distributeIP(input, spread)
%
% IP Arguments	-
%		  1. input - The input signal row vector.
%		  2. spread - The value of input spread.
% Return Args	- 
%		  1. center - the index of the center
%                 2. distOP - The distributed OP signal.
%
%         (c), 2005, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------

center = [];

% Make the gaussian kernel.
x 	= (0:1:49);
sigma 	= 0.8;
mu 	= 0;
y = (1/ (sigma * sqrt(2*pi) ) ) * exp(-1 * (((x -3  - mu).^2) / (2*sigma.^2)) );
y = y ./ max(y);	% Normalize in the range [0 1]

% Find the maximum and minimum in the input vector
vd_MaxIP = max(input);
vd_MinIP = min(input);

% Find the range of input values.
vd_Diff = vd_MaxIP - vd_MinIP;

% Initialize the distributed output vector.
distOP = [];
vd_OPCol  = [];

% Iterate through the Input vector
vi_Len = length(input);
vi_CenterNeuron = [];
for i = 1:vi_Len
	vd_OPCol = zeros(1, spread);
        if(centerIn == -1)
	    % Find the center neuron for this input value.
	    if(vd_Diff ==0)
	        	vi_CenterNeuron = round((input(i)/2) * (spread -1) + 1);
        	else
	        	vi_CenterNeuron = round( abs(((input(i) - vd_MinIP)/vd_Diff) * (spread -1))) + 1; % One based index.
	    end;

	    if(vi_CenterNeuron <=0) 
	        	vi_CenterNeuron = 1;
	    end;
	    if (vi_CenterNeuron > 50) 
	        	vi_CenterNeuron = 50;
            end;
	    center(i) = vi_CenterNeuron;
        else
            vi_CenterNeuron = centerIn;
            center(i)       = centerIn;
        end;

	if(vi_CenterNeuron - 3 > 0)
		vd_OPCol(1,vi_CenterNeuron - 3) = y(1) * input(i);
	end;

	if(vi_CenterNeuron - 2 > 0)
		vd_OPCol(1,vi_CenterNeuron - 2) = y(2) * input(i);
	end;
		
	if(vi_CenterNeuron - 1 > 0)
		vd_OPCol(1,vi_CenterNeuron - 1) = y(3) * input(i);
	end;

	% The Center Neuron
	vd_OPCol(vi_CenterNeuron) = y(4) * input(i);

	if(vi_CenterNeuron + 1 <= spread)
		vd_OPCol(1,vi_CenterNeuron + 1) = y(5) * input(i);
	end;

	if(vi_CenterNeuron + 2 <= spread)
		vd_OPCol(1,vi_CenterNeuron + 2) = y(6) * input(i);
	end;

	if(vi_CenterNeuron + 3 <= spread)
		vd_OPCol(1,vi_CenterNeuron + 3) = y(7) * input(i);
	end;
	vd_OPCol = vd_OPCol';	
	if(i ==1)
		distOP = vd_OPCol;
	else
		distOP = horzcat(distOP, vd_OPCol);
	end;
end;
