function install

% save curren working directory
rwd=pwd;

% make spike filter in offline
SF = { 'spikes2alpha' 'spikes2exp' 'spikes2count' };
for i=1:length(SF)
  if exist(SF{i}) == 3
    fprintf('%s.%s exists. No compilation necessary.\n',SF{i},mexext);    
  else
    fprintf('Compiling %s ...',SF{i});
    eval(sprintf('mex %s.c',SF{i}));
    fprintf('\b\b\b\b. Done\n');
  end
end

% make pdelta C-core
cd('@pdelta/private');
if exist('cpdelta') == 3
  fprintf('cpdelta.%s exists. No  compilation necessary.\n',mexext);
else
  fprintf('Compiling cpdelta ...');
  mex cpdelta.c
  fprintf('\b\b\b\b. Done.\n');
end
cd(rwd);

% make Gavin Cawley's SVM Toolbox 
cd('svm_toolbox/@smosvctutor');
if exist('smosvctrain') == 3
  fprintf('smosvctrain.%s exists. No compilation necessary.\n',mexext);
else
  fprintf('Compiling smosvctrain ...');
  mex smosvctrain.cpp InfCache.cpp LrrCache.cpp SmoTutor.cpp
  fprintf('\b\b\b\b. Done.\n');
end
cd(rwd);

cd('svm_toolbox/@rbf');
if exist('evaluate') == 3
  fprintf('evaluate.%s exists. No compilation necessary.\n',mexext);      
else
  fprintf('Compiling evaluate ...');
  mex evaluate.c
  fprintf('\b\b\b\b. Done.\n');
end
cd(rwd);


fprintf('Learning-Tool *succesfully* installed.\n\n');
