function [R] = wo_delay_validate(nmc, readouts, I)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Desc	- This file is used to perform the simulation of the two joint 
%			robot arm in an online fashion. The inputs to the liquid are
%			non delayed.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File		- wo_delay_validate.m
% Author	- Prashant Joshi ( joshi@igi.tu-graz.ac.at )
% Date		- 12-08-2003
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% ***************** BEGIN MICHAEL *******************
% Difference: In this script I only set-up the input for the whole
% time and then call simulate. Even though you are using
% feedback-neurons, you need to have some external input too, even
% though it is not used within the simulation.
% ****************** END MICHAEL ********************
global TSTIM DT NO_IP_CHANNELS NO_NOISE_CHANNELS
for i = 1 :NO_IP_CHANNELS+NO_NOISE_CHANNELS
        S.channel(i).data    = I.channel(i).data;
        S.channel(i).dt      = -1;
        S.channel(i).spiking = 1;
end;
for i = (NO_IP_CHANNELS+NO_NOISE_CHANNELS+1) :(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2)
        data = I.channel(i).data;
        S.channel(i).data    = [data];
        S.channel(i).dt      = DT;
        S.channel(i).spiking = 0;
end;

%for i = 2 :3
%        S.channel(i).data    = I.channel(i).data;
%        S.channel(i).dt      = DT;
%        S.channel(i).spiking = 0;
%end;

% Add some information to Stimuli.
S.info(1).Tstim = TSTIM;
S.info(1).dt    = DT;

% Run the simulation for all the time steps.
% Reset the neural microcircuit object.
reset(nmc);

R=simulate(nmc,TSTIM,S);
