% collect the stimulus and response pairs for training and testing
InputDist = timer_attr_stimulus;

[train_response,train_stimuli] = collect_sr_data(nmc, ...
                                                 InputDist,...
		                                 fileStr,...
                                                 trnIdx,...
                                                 NTRAIN, ...
                                                 TSTIM);
[test_response,test_stimuli] = collect_sr_data(nmc, ...
                                               InputDist,...
                                               fileStr,...
                                               tstIdx,...
                                               NTEST, ...
                                               TSTIM);
    
ltrain_val  = response2states(train_response,[], ...
                              [0:DT:TSTIM]);
ltest_val   = response2states(test_response,[], ...
                              [0:DT:TSTIM]);
    
% add the readouts
readout{1} = external_readout('targetFunction',timer_readout1,...
                              'description','first timer readout');

if(~isempty(strfind(fileStr, 'dual_stim')))
    readout{2} = external_readout('targetFunction',timer_readout2,...
                              'description','second timer readout');
end
[trained_readouts] = train_readouts(readout,ltrain_val, train_stimuli,...
                                    ltest_val, test_stimuli);
if(~isempty(strfind(fileStr, 'dual_stim')))
    dual_online_validation;
else
    online_validation;
end;
