%-------------------------------------------------------------------------
% Desc - This part of the code performs the closed loop validation process.
%        First it converts the open loop readout to a closed loop readout
%        and then perform the simulation in a closed loop with new unseen 
%        inputs for validation.
%
%        (c), 2005, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------
fprintf('\n--------------------------------------------------------');
fprintf('\n\nNow starting the closed loop validation  process\n\n');
fprintf('--------------------------------------------------------\n');

%-------------------------------------------------------------------------
% Part I - Construct the transformed liquid
%-------------------------------------------------------------------------
[nmc, roIdx1] = transform_readout(nmc, trained_readouts{1});
% find the Teacher Feedback Neuron
pools = get(nmc, 'pool');
poolinp = pools(3);
teacher_fb_neuron(1) = poolinp.neuronIdx;

% Create feedback connections
csim('connect', teacher_fb_neuron(1), roIdx1);

% Switch feedback on
csim('set', teacher_fb_neuron(1), 'feedback', 1);

% add recorder to record the output of our transformed readouts.
rec = csim('create', 'Recorder');
csim('set', rec, 'dt', DT);
csim('connect', rec, roIdx1, 'output');


%-------------------------------------------------------------------------
% Part II - Collect the stimulus response pairs for validation
%-------------------------------------------------------------------------
fprintf('\n--------------------------------------------------------');
fprintf('\n\nCollecting the stimulus-response pairs for validation\n\n');
fprintf('--------------------------------------------------------\n');

%-------------------------------------------------------------------------
% Part II - Perform Validation
%-------------------------------------------------------------------------
tic;
fprintf('\n--------------------------------------------------------');
fprintf('\n\nRunning %i simulations in closed loop\n\n', NVALIDATE);
fprintf('--------------------------------------------------------\n');
plot_labels = {'fading attractor readout1' 'switch 1' 'fading attractor readout 2' 'switch 2'};
for i = 1 :NVALIDATE
    S = generate(InputDist, fileStr, vldIdx(i));
    [R] = wo_delay_validate(nmc, trained_readouts, S);

    traces = csim('get', rec, 'traces');

    % now save the data
    [fname, err] = sprintf('%s/%s%g.mat', resultPath, saveStr, i);
    save(fname, 'S', 'traces', 'R', 'DT', 'TSTIM')
end

% Switch feedback off
csim('set', teacher_fb_neuron(1), 'feedback', 0);
