%-------------------------------------------------------------------------
% Desc - Modifies the existing circuit so that the dynamic synapses are
%        replaces by static synapses (approximation), with right
%        weight distribution.
%
%        (c), 2006, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------

  global NVALIDATE
  EPSILON = 1e-999;
  MAGFAC  = 1.7494;
  % first calculate the mean firing rate of the original circuit
  fprintf('\n\nModifying circuit\n\n');
  mu = 0;
  for i = 1:NVALIDATE
      [fn, e] = sprintf('./results_dynamic/dual_run%g.mat', i);
      load(fn);
      mu = mu + length([R{1}.channel(:).data])/(length(R{1}.channel)*R{1}.Tsim);
  end
  mu = mu/NVALIDATE;

  % now calculate the scaling factor to convert the synapses

  %----------------
  % EE
  %----------------
  U = 0.5;
  D = 1.1;
  F = 0.05;

  ustEE = U/(1 - (1-U)*exp(-1/(mu*F)));
  rstEE = (1 - exp(-1/(mu*D))) / (1 - ((1-ustEE)*(exp(-1/(mu*D)))));

  %----------------
  % EI
  %----------------
  U = 0.05;
  D = 0.125;
  F = 1.2;

  ustEI = U/(1 - (1-U)*exp(-1/(mu*F)));
  rstEI = (1 - exp(-1/(mu*D))) / (1 - ((1-ustEI)*(exp(-1/(mu*D)))));
  
  %----------------
  % IE
  %----------------
  U = 0.25;
  D = 0.7;
  F = 0.02;

  ustIE = U/(1 - (1-U)*exp(-1/(mu*F)));
  rstIE = (1 - exp(-1/(mu*D))) / (1 - ((1-ustIE)*(exp(-1/(mu*D)))));
  
  %----------------
  % II
  %----------------
  U = 0.32;
  D = 0.144;
  F = 0.06;

  ustII = U/(1 - (1-U)*exp(-1/(mu*F)));
  rstII = (1 - exp(-1/(mu*D))) / (1 - ((1-ustII)*(exp(-1/(mu*D)))));

  %-----------------
  % Now rescale the circuit
  %-----------------
  c = get(nmc, 'conn');
  synIdx = c(5).synapseIdx;

  for i = 1:length(synIdx)
      [preNeuron, postNeuron] = csim('get', synIdx(i), 'connections');
      preType = csim('get', preNeuron, 'type');
      postType = csim('get', postNeuron, 'type');

      % set U to 1, D and F to 1e-99
      csim('set', synIdx(i), 'U', 1, 'D', EPSILON, 'F', EPSILON');

      % EE
      if(preType == 2 & postType == 2)
          scaleF = ustEE * rstEE;
      end
      % EI
      if(preType == 2 & postType == 1)
          scaleF = ustEI * rstEI;
      end
      % IE
      if(preType == 1 & postType == 2)
          scaleF = ustIE * rstIE;
      end
      % II
      if(preType == 1 & postType == 1)
          scaleF = ustII * rstII;
      end
      scaleF = scaleF * MAGFAC;

      %rescale the weight
      wOld = csim('get', synIdx(i), 'W');
      csim('set', synIdx(i), 'W', wOld * scaleF); 
  end
