%--------------------------------------------------------------------------
% Desc - Creates the liquid for the simulation
%
% Also See - load_params.m
%
%            (c), 2004, Prashant Joshi ( joshi@igi.tugraz.at )
%--------------------------------------------------------------------------
% create the input neurons
% Create an input pool of  spiking input neurons.
[nmc, pin] = add(nmc, 'Pool', 'origin', ORIG_POOL_IP, 'size', ...
                           [1 1 NO_IP_CHANNELS], 'type', ...
                           NTYPE_IP, 'frac_EXC', 1.0);
% create the pool of neurons which send noise to the circuit
[nmc, pnoise] = add(nmc, 'Pool', 'origin', ORIG_POOL_NOISE, 'size', ...
                           [1 1 NO_NOISE_CHANNELS], 'type', ...
                           NTYPE_IP, 'frac_EXC', 1.0);

% create the pool of teacher feedback neurons
[nmc, pfb1] = add(nmc, 'Pool', 'origin', ORIG_POOL_FB1, 'size', ...
                           [1 1 NO_READOUTS/2], 'type', ...
                           NTYPE_TFB, 'frac_EXC', 1.0);
[nmc, pfb2] = add(nmc, 'Pool', 'origin', ORIG_POOL_FB2, 'size', ...
                           [1 1 NO_READOUTS/2], 'type', ...
                           NTYPE_TFB, 'frac_EXC', 1.0);
                
% Create the liquid
[nmc, poolnmc] = add(nmc, 'Pool', 'origin', ORIG_POOL_NMC, 'size', CIRCUIT_SIZE, ...
                    'frac_EXC', 0.8, ...
		    'type', 'LifNeuron', 'Neuron.Vthresh', 0.015, ...
                     'Neuron.Vreset', [0 0], 'Neuron.Vinit', [0 0], ...
                     'Neuron.Iinject', [13.5e-9 14.5e-9], 'Neuron.Trefract', 0.003, ...
                     'Neuron.Inoise', [4e-9 5e-9]);

% Connect the  input neurons to the liquid
% The first two neurons simulate the start and stop burst
[nmc, cip] = add(nmc, 'Conn', 'src', pin, 'dest', [6 0 4; 10 4 8], ...
                             'type', STYPE_IP, 'Cscale', csip2liq, ...
                             'Wscale', wsip2liq, 'rescale', 0, 'lambda', lamip2liq);
[nmc, cnoise] = add(nmc, 'Conn', 'src', pnoise, 'dest', poolnmc,...%[6 0 4; 10 4 11], ...
                             'type', STYPE_IP, 'Cscale', csnoise, ...
                             'Wscale', wsnoise, 'rescale', 0, 'lambda', lamnoise);
[nmc, cfb1] = add(nmc, 'Conn', 'src', pfb1, 'dest', [6 0 15; 10 4 27], ...
                             'type', STYPE_TFB, 'Cscale', csfb, ...
                             'Wscale', wsfb, 'rescale', 0, 'lambda', lamfb);         
[nmc, cfb2] = add(nmc, 'Conn', 'src', pfb2, 'dest', [6 0 15; 10 4 27], ...
                             'type', STYPE_TFB, 'Cscale', csfb, ...
                             'Wscale', wsfb, 'rescale', 0, 'lambda', lamfb);         
                    
% make recurrent connections in the liquid
[nmc, cr] = add(nmc, 'Conn', 'dest', poolnmc, 'src', poolnmc,...
                         'Cscale', csliq, 'Wscale', wsliq, 'lambda', lamliq,...
		                 'type', STYPE_CIRCUIT);

% now add recorders
nmc = record(nmc, 'Pool', poolnmc, 'Field', 'spikes','dt', DT);

% now save the circuit
[fname, err] = sprintf('%s/nmc.mat', circuitPath);
save(fname, 'nmc');
