%--------------------------------------------------------------------------
% Desc - This file defines the parameters for the simulation
%
%            (c), 2005, Prashant Joshi (joshi@igi.tugraz.at)
%--------------------------------------------------------------------------
global NO_FB_CHANNELS NO_IP_CHANNELS TSTIM DT KERNEL_SIZE TSTART TBURST
global TRESET TRESET1 TRESET2 BURSTRATE HIVAL LOVAL POISSON_NOISE_RATE NO_NOISE_CHANNELS
global NTRAIN NTEST NVALIDATE
global NOISEALPHA
%--------------------------------------------------------------------------
% Simulation Parameters
%--------------------------------------------------------------------------
% the time step of simulation in seconds
DT = 5e-3;

% the total time of simulation in seconds (1 second)
TSTIM = 1000e-3;

% the time of the start burst (100 msec)
TSTART = 100e-3;

% duration of the burst
TBURST = 50e-3;

% the rate of burst that signals the start
BURSTRATE = 200;

% Time that the timers take to reset(by decaying or gaining)
TRESET = 600e-3;

% Time at which first simultaneuous timer resets
TRESET1 = 400e-3;
% Time at which second simultaneuous timer resets
TRESET2 = 600e-3;

% the higher the value the more the plots that will be generated
PLOTTING_LEVEL = 1;

% number of training iterations
NTRAIN = 120;

% number of testing iterations
NTEST = 30;

% number of validation runs
NVALIDATE = 100;

% The size of kernel window for the open loop readouts
KERNEL_SIZE = 30e-3;

% The highest point on the ramp
HIVAL = 9;

% the lowest point on the ramp
LOVAL = 0;

% rate of poisson noise
POISSON_NOISE_RATE = 10;

% the multiplying factor for noise in teacher feedback
NOISEALPHA = 1e-3;

% do we want to regenerate the circuit and inputs
REGENERATE = 0;

SET_STATIC_SYNAPSES = 1;
if(SET_STATIC_SYNAPSES ==1)
    inputPath = './data_static/inputs';
    circuitPath = './data_static/circuits';
    resultPath  = './results_static';
else
    inputPath = './data_dynamic/inputs';
    circuitPath = './data_dynamic/circuits';
    resultPath  = './results_dynamic';
end

%--------------------------------------------------------------------------
% Liquid parameters
%--------------------------------------------------------------------------
% circuit type
nmc = neural_microcircuit;

% neuron type
NTYPE_CIRCUIT = 'LifNeuron';
NTYPE_IP = 'SpikingInputNeuron';
NTYPE_TFB = 'AnalogFeedbackNeuron';

% synapse types
STYPE_IP = 'StaticSpikingSynapse';
STYPE_TFB = 'StaticAnalogSynapse';
STYPE_CIRCUIT ='DynamicSpikingSynapse';

% circuit size
CIRCUIT_SIZE = [5 5 24];

% number of input channels (excluding feedback)
NO_IP_CHANNELS = 1;
NO_NOISE_CHANNELS = 5; % channels sending poisson noise

% number of readouts
NO_READOUTS = 2;
NO_FB_CHANNELS = NO_READOUTS;

% define the origin of input pool, liquid and the linear readout
ORIG_POOL_NMC = [6 0 4];
ORIG_POOL_NOISE  = [1 1 11];
ORIG_POOL_FB1  = [1 1 24];
ORIG_POOL_FB2  = [1 1 25];
ORIG_POOL_IP  = [1 1 5];

% set the connection parameters

% for connections from ip --> liq
wsip2liq  = 0.5;
csip2liq  = 10;
lamip2liq = 5;

% for connections from noise-->liq
wsnoise = 0.05;
csnoise = 10;
lamnoise = 5;

% for connection that simulate teacher feedback
wsfb   = 0.4;
csfb = 10;
lamfb  = 5.0;

% for recurrent connections liq --> liq
wsliq  = 2;
csliq  = 1;
lamliq = 3;
