%-------------------------------------------------------------------------
% Desc - This file launches the experiment
%
%        (c), 2005, Prashant Joshi (joshi@igi.tugraz.at)
%-------------------------------------------------------------------------


%-------------------------------------------------------------------------
% CASE 1 - The gaining attractor
%-------------------------------------------------------------------------

clear all classes;
close all;
clc;
load_params;

if(SET_STATIC_SYNAPSES == 1)
    fprintf('\n\n***\n Running simulation with STATIC synapses in the circuit\n\n***\n');
else
    fprintf('\n\n***\n Running simulation with DYNAMIC synapses in the circuit\n\n***\n');
end
fprintf('Running the simulation for the decaying attractor\n\n');


if(REGENERATE == 1)
    fprintf('\n\nCreating inputs...\n\n');
    create_inputs;
    fprintf('\n\nCreating circuit...\n\n');
    make_liquid;
else
    [fname, err] = sprintf('%s/nmc.mat', circuitPath);
    load(fname);
end
% If we want to use static synapses in the circuit
if(SET_STATIC_SYNAPSES == 1)
    modify_circuit;
end;

[fileStr, err] = sprintf('%s/gain_stim_', inputPath);
saveStr = 'gain_run';

% divide the stimulus into training, testing and validation subsets
trnIdx = (1:1:NTRAIN);
tstIdx = (NTRAIN+1:1:NTRAIN+NTEST);
vldIdx = (NTRAIN+NTEST+1 : 1 : NTRAIN+NTEST+NVALIDATE);

% now run the simulation
run_it;


%-------------------------------------------------------------------------
% CASE 2 - The decaying attractor
%-------------------------------------------------------------------------

%clear all classes;
%close all;
%clc;
%
%fprintf('Running the simulation for the gaining attractor\n\n');
%
%load_params;
%
%[fname, err] = sprintf('%s/nmc.mat', circuitPath);
%load(fname);
%
%[fileStr, err] = sprintf('%s/decay_stim_', inputPath);
%saveStr = 'decay_run';
%
%% divide the stimulus into training, testing and validation subsets
%trnIdx = (1:1:NTRAIN);
%tstIdx = (NTRAIN+1:1:NTRAIN+NTEST);
%vldIdx = (NTRAIN+NTEST+1 : 1 : NTRAIN+NTEST+NVALIDATE);
%
%% now run the simulation
%run_it;

%-------------------------------------------------------------------------
% CASE 3 - The case with simultaneuous attractors
%-------------------------------------------------------------------------
 
clear all classes;
close all;
clc;
 
fprintf('Running the simulation for the dual attractors\n\n');
 
load_params;
 
[fname, err] = sprintf('%s/nmc.mat', circuitPath);
load(fname);
modify_circuit;
 
[fileStr, err] = sprintf('%s/dual_stim', inputPath);
saveStr = 'dual_run';
 
% divide the stimulus into training, testing and validation subsets
trnIdx = (1:1:NTRAIN);
tstIdx = (NTRAIN+1:1:NTRAIN+NTEST);
vldIdx = (NTRAIN+NTEST+1 : 1 : NTRAIN+NTEST+NVALIDATE);
 
% now run the simulation
run_it; 
