function ext_signal = design_ext_signals()

global TSTIM DT TSTART TBURST BURSTRATE
global NTRAIN NTEST NVALIDATE
global POISSON_NOISE_RATE NO_NOISE_CHANNELS

time = (0:DT:TSTIM);

totalSamples = NTRAIN + NTEST + NVALIDATE;
timeBurst = (0:DT:TBURST);
rate = BURSTRATE * ones(size(timeBurst));
ext_signal = rate2spikes(rate, DT, totalSamples, TBURST);

rate_noise = POISSON_NOISE_RATE * ones(size(time));
noise_signal = rate2spikes(rate_noise, DT, totalSamples*NO_NOISE_CHANNELS, TSTIM);

for i = 1:totalSamples
    ext_signal{i}.channel(1).data = ext_signal{i} + TSTART;
    for j = 1:NO_NOISE_CHANNELS
        ext_signal{i}.channel(1+j).data = noise_signal{((i-1)*NO_NOISE_CHANNELS + j)};
    end
end
