%--------------------------------------------------------------------------
% Desc - This script creates the stimulus and stores it at the path
%        'inputPath'
%
%        (c), 2005, Prahshant Joshi (joshi@igi.tugraz.at)
%--------------------------------------------------------------------------

global NO_FB_CHANNELS NO_IP_CHANNELS TSTIM DT KERNEL_SIZE TSTART TBURST
global TRESET TRESET1 TRESET2 BURSTRATE HIVAL LOVAL POISSON_NOISE_RATE NO_NOISE_CHANNELS
global NTRAIN NTEST NVALIDATE
global NOISEALPHA 

time = (0:DT:TSTIM);
time_start = (0:DT:(TSTART-DT));
time_reset = (TSTART:DT:(TSTART+TRESET));
time_end = ((TSTART+TRESET+DT):DT:TSTIM);


% first clear the directory of the old data
[cmd, e] = sprintf('rm %s/*', inputPath);
system(cmd);

% now generate the first 6 channels (1 IP + 5 noise)
e = design_ext_signals;

% design the stimulus name prefixes
fileStr = {'decay_stim_', 'gain_stim_', 'dual_stim'};
DECAY   = {1, 0, 1};

for i = 1:length(e) % no of ext-signals
    for j = 1:3     % no of variations (decay and gain)
        for k = 1:(NO_IP_CHANNELS + NO_NOISE_CHANNELS)
            S.channel(k).data = e{i}.channel(k).data;
            S.channel(k).dt   = -1;
            S.channel(k).spiking = 1;
        end
        if(j == 1)
            timer_data = linspace(HIVAL, LOVAL, length(time_reset));
            [fname, err] = sprintf('%s/%s%g.mat', inputPath, fileStr{j}, i);
            isDecay = DECAY{j};
            timer_roval = [(LOVAL * ones(size(time_start))) ...
                            timer_data ...
                            (LOVAL * ones(size(time_end)))]; 
            
	    data = add_noise(timer_roval, NOISEALPHA);
	    data = data(1:end-1);
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+1).data = [0 data];
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+1).dt = DT;
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+1).spiking = 0;  
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2).data = [0];
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2).dt = DT;
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2).spiking = 0;  
	
	    S.info(1).dt = DT;
	    S.info(1).Tstim = TSTIM;
	    S.info(1).timer_ro1val = [0 timer_roval(1:end-1)];
	    S.info(1).timer_ro2val = [0];
	    S.info(1).isDecay = isDecay; 
        elseif(j ==2)
            timer_data = linspace(LOVAL, HIVAL, length(time_reset));
            [fname, err] = sprintf('%s/%s%g.mat', inputPath, fileStr{j}, i);
            isDecay = DECAY{j};
            timer_roval = [(LOVAL * ones(size(time_start))) ...
                            timer_data ...
                            (HIVAL * ones(size(time_end)))]; 
	    data = add_noise(timer_roval, NOISEALPHA);
	    data = data(1:end-1);
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+1).data = [0 data];
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+1).dt = DT;
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+1).spiking = 0;  
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2).data = [0];
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2).dt = DT;
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2).spiking = 0;  

            S.info(1).dt = DT;
	    S.info(1).Tstim = TSTIM;
	    S.info(1).timer_ro1val = [0 timer_roval(1:end-1)];
	    S.info(1).timer_ro2val = [0];
	    S.info(1).isDecay = isDecay; 
        else
            isDecay = DECAY{j};
            [fname, err] = sprintf('%s/%s%g.mat', inputPath, fileStr{j}, i);
            time_start = (0:DT:(TSTART-DT));
            time_reset1 = (TSTART:DT:(TSTART+TRESET1));
            time_end1 = ((TSTART+TRESET1+DT):DT:TSTIM);
            time_reset2 = (TSTART:DT:(TSTART+TRESET2));
            time_end2 = ((TSTART+TRESET2+DT):DT:TSTIM);
            timer1_data = linspace(HIVAL, LOVAL, length(time_reset1));
            timer_ro1val = [(LOVAL * ones(size(time_start))) ...
                            timer1_data ...
                            (LOVAL * ones(size(time_end1)))]; 
            
	    data1 = add_noise(timer_ro1val, NOISEALPHA);
	    data1 = data1(1:end-1);
            timer2_data = linspace(HIVAL, LOVAL, length(time_reset2));
            timer_ro2val = [(LOVAL * ones(size(time_start))) ...
                            timer2_data ...
                            (LOVAL * ones(size(time_end2)))]; 
            
	    data2 = add_noise(timer_ro2val, NOISEALPHA);
	    data2 = data2(1:end-1);
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+1).data = [0 data1];
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+1).dt = DT;
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+1).spiking = 0;  
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2).data = [0 data2];
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2).dt = DT;
	    S.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2).spiking = 0;  

            S.info(1).dt = DT;
	    S.info(1).Tstim = TSTIM;
	    S.info(1).timer_ro1val = [0 timer_ro1val(1:end-1)];
	    S.info(1).timer_ro2val = [0 timer_ro2val(1:end-1)];
	    S.info(1).isDecay = isDecay; 
        end
                          
        
        save(fname, 'S');
    end
end
