function plot(this,input)
global NO_IP_CHANNELS NO_FB_CHANNELS DT TSTIM NO_NOISE_CHANNELS

nPanels = 2;
if(input.info(1).timer_ro2val == 0)
    nPanels = 3;
end
time = (0:DT:TSTIM);
col = 'r';
subplot(nPanels,1,1);
for i = 1:NO_IP_CHANNELS+NO_NOISE_CHANNELS
    st = input.channel(i).data;
    col(i>1) = 'k';
    line([st;st],i+[0.3; -0.3]*ones(1,length(st)),'Color',col,'Linewidth',1.5);
    axis([0 input.info(1).Tstim (-2) (NO_IP_CHANNELS+NO_NOISE_CHANNELS+1)]);
end;
xlabel('External Input');
title('Inputs to the circuit', 'fontsize', 14, 'fontweight', 'bold');

subplot(nPanels,1,2);
plot(time, input.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+1).data, 'k', 'linewidth',2);
xlabel('Teacher Feedback 1');

if(nPanels == 3)
    subplot(nPanels,1,3);
    plot(time, input.channel(NO_IP_CHANNELS+NO_NOISE_CHANNELS+2).data, 'k', 'linewidth',2);
    xlabel('Teacher Feedback 2');
end
