
clear all classes;
close all;

addpath('../timer_attractor');
load_params;
time = (0:DT:TSTIM);

timer1_data.CC = [];
timer1_data.NRMSE = [];

timer2_data.CC = [];
timer2_data.NRMSE = [];

timer3_data.CC = [];
timer3_data.NRMSE = [];

for i = 1:NVALIDATE
    [fname, err] = sprintf('../timer_attractor/results_dynamic/dual_run%g.mat', i);
    load(fname);
    
    % now calculate the statistical data for timer 1
    cc1 = corr_coef(S.info(1).timer_ro1val(1:end-1), traces.channel(1).data);
    timer1_data.CC = [timer1_data.CC; [cc1]];
    nrmse1 = nrmse(S.info(1).timer_ro1val(1:end-1), traces.channel(1).data, DT, TSTIM);
    timer1_data.NRMSE = [timer1_data.NRMSE; [nrmse1]];
    
    % now calculate the statistical data for timer 2
    cc1 = corr_coef(S.info(1).timer_ro2val(1:end-1), traces.channel(2).data);
    timer2_data.CC = [timer2_data.CC; [cc1]];
    nrmse1 = nrmse(S.info(1).timer_ro2val(1:end-1), traces.channel(2).data, DT, TSTIM);
    timer2_data.NRMSE = [timer2_data.NRMSE; [nrmse1]];

    [fname, err] = sprintf('../timer_attractor/results_dynamic/gain_run%g.mat', i);
    load(fname);

    % now calculate the statistical data for timer 3
    cc1 = corr_coef(S.info(1).timer_ro1val(1:end-1), traces.channel(1).data);
    timer3_data.CC = [timer3_data.CC; [cc1]];
    nrmse1 = nrmse(S.info(1).timer_ro1val(1:end-1), traces.channel(1).data, DT, TSTIM);
    timer3_data.NRMSE = [timer3_data.NRMSE; [nrmse1]];
end
fname = 'stat_timer_exp.mat';
save(fname, 'timer1_data', 'timer2_data', 'timer3_data');
