
clear all classes;
close all;

addpath('../multi_layered_lsqnonneg');
load_params;
time = (0:DT:TSTIM);

load('../multi_layered_lsqnonneg/results/workspace.mat');

att_data.CC = [];
att_data.NRMSE = [];

sddp_data.CC = [];
sddp_data.NRMSE = [];

prod_data.CC = [];
prod_data.NRMSE = [];

for i = 1:NVALIDATE
    [fname, err] = sprintf('../multi_layered_lsqnonneg/results/run%g.mat', i);
    load(fname);
    resp = readout_resp(trained_readouts,R{1}, S,{ 'response2states' [0:DT:TSTIM] });
    roch1_val  = resp.readout(1).val;
    roch2_val  = resp.readout(2).val;
    rofb_val   = resp.readout(3).val;
    roprod_val = resp.readout(4).val;
    roatt_val = resp.readout(5).val;
    rosddp_val = resp.readout(6).val;
    rateR1 = find_target_rate(S, (1:1:8));
    rateR2 = find_target_rate(S, (9:1:16));
    timesBox = find_shade_times(rateR1, rateR2); 
    for j = 1:length(timesBox.box)
        timeHi(2*j-1) = timesBox.box(j).startTime;
        timeHi(2*j) = timesBox.box(j).endTime;
    end;

    % now calculate the statistical data for attention switching
    target_att = S.info(1).roampl_val;%target_att_swtch(S.info(1).roch1_val, timeHi);
    cc1 = corr_coef(roatt_val, target_att);
    cc2 = corr_coef(roatt_val, S.info(1).roch1_val);
    cc3 = corr_coef(roatt_val, 2*S.info(1).roch1_val);
    att_data.CC = [att_data.CC; [cc1 cc2 cc3]];

    nrmse1 = nrmse(target_att, roatt_val,DT,TSTIM);
    nrmse2 = nrmse(S.info(1).roch1_val, roatt_val, DT, TSTIM);
    nrmse3 = nrmse(2*S.info(1).roch1_val, roatt_val, DT, TSTIM);
    att_data.NRMSE = [att_data.NRMSE; [nrmse1 nrmse2 nrmse3]];

    % now calculate the statistical data for state dependent differential
    % processing
    target_sddp_val = S.info(1).roattn_val;%target_sddp(S.info(1).roch1_val, S.info(1).roch2_val, timeHi); 
    cc1 = corr_coef(rosddp_val, target_sddp_val);
    cc2 = corr_coef(rosddp_val, abs(S.info(1).roch2_val - S.info(1).roch1_val));
    cc3 = corr_coef(rosddp_val, abs(S.info(1).roch2_val+S.info(1).roch1_val)); 
    cc4 = corr_coef(rosddp_val, S.info(1).roch1_val); 
    cc5 = corr_coef(rosddp_val, S.info(1).roch2_val); 
    sddp_data.CC = [sddp_data.CC; [cc1 cc2 cc3 cc4 cc5]];

    nrmse1 = nrmse(target_sddp_val, rosddp_val, DT, TSTIM); 
    nrmse2 = nrmse(abs(S.info(1).roch2_val - S.info(1).roch1_val), rosddp_val, DT, TSTIM);
    nrmse3 = nrmse(abs(S.info(1).roch1_val + S.info(1).roch2_val), rosddp_val, DT, TSTIM);
    nrmse4 = nrmse(S.info(1).roch1_val, rosddp_val, DT, TSTIM);
    nrmse5 = nrmse(S.info(1).roch2_val, rosddp_val, DT, TSTIM);
    sddp_data.NRMSE = [sddp_data.NRMSE; [nrmse1 nrmse2 nrmse3 nrmse4 nrmse5]];

    % now calculate the statistical data for product readout.
    cc1 = corr_coef(roprod_val, S.info(1).roprod_val);
    prod_data.CC = [prod_data.CC; [cc1]];
    nrmse1 = nrmse(S.info(1).roprod_val, roprod_val, DT, TSTIM);
    prod_data.NRMSE = [prod_data.NRMSE; [nrmse1]];
end
fname = 'stat_multi_exp.mat';
save(fname, 'att_data', 'sddp_data', 'prod_data');
