
clear all classes;
close all;

addpath('../cont_attr_lif_neuron_switch');
load_params;
time = (0:DT:TSTIM);

CA_data.CC = [];
CA_data.NRMSE = [];

switch_data.CC = [];
switch_data.NRMSE = [];

diff_data.CC = [];
diff_data.NRMSE = [];

for i = 1:NVALIDATE
    [fname, err] = sprintf('../cont_attr_lif_neuron_switch/results/w/run%g.mat', i);
    load(fname);
    des.channel(1).data = S.info(1).ro1val(1:end-1);   %ro1
    des.channel(2).data = S.info(1).rate2val(1:end-1);   %ro1
    des.channel(3).data = S.info(1).ro2val(1:end-1);   %ro1
    des.channel(4).data = S.info(1).car_switch_val(1:end-1);   %ro1
    des.channel(5).data = S.info(1).carval(1:end-1);  
    
    % calculate the statistical data for CA
    cc1 =  corr_coef(traces.channel(5).data, des.channel(5).data);
    nrmse1 = nrmse(des.channel(5).data, traces.channel(5).data, DT, TSTIM); 
    CA_data.CC = [CA_data.CC; [cc1]];
    CA_data.NRMSE = [CA_data.NRMSE; [nrmse1]];

    % calculate the statistical data for the switch readout
    cc1 = corr_coef(traces.channel(4).data, des.channel(4).data); 
    cc2 = corr_coef(traces.channel(4).data, des.channel(2).data); 
    nrmse1 = nrmse(des.channel(4).data, traces.channel(4).data, DT, TSTIM);
    nrmse2 = nrmse(des.channel(2).data, traces.channel(4).data, DT, TSTIM);
    switch_data.CC = [switch_data.CC; [cc1 cc2]];
    switch_data.NRMSE = [switch_data.NRMSE; [nrmse1 nrmse2]];

    % now calculate the statistical data for the readout (r1 - CA)
    cc1 = corr_coef(traces.channel(3).data, des.channel(3).data);
    cc2 = corr_coef(traces.channel(3).data, des.channel(5).data); 
    cc3 = corr_coef(traces.channel(3).data, des.channel(1).data);
    nrmse1 = nrmse(des.channel(3).data, traces.channel(3).data, DT, TSTIM);
    nrmse2 = nrmse(des.channel(5).data, traces.channel(3).data, DT, TSTIM);
    nrmse3 = nrmse(des.channel(1).data, traces.channel(3).data, DT, TSTIM); 
    diff_data.CC = [diff_data.CC; [cc1 cc2 cc3]];
    diff_data.NRMSE = [diff_data.NRMSE; [nrmse1 nrmse2 nrmse3]];
end
fname = 'stat_cont_attr_exp.mat';
save(fname, 'CA_data', 'switch_data', 'diff_data');
