function this = spiking_readout_plot(S,R, trained_readouts, txt, nmc)
global NO_READOUTS TSTIM RATE_READOUT RATE_NOISE DT NO_IP_CHANNELS


time = (0:DT:TSTIM);
black = 'k';
col_des = 'k';
col_obs = 'r';
col_r1 = 'r';
col_r2 = 'b';
col_shade = [215 215 215]/255;
 
 resp = readout_resp(trained_readouts,R{1}, S,{ 'response2states' [0:DT:TSTIM] });
 roch1_val  = resp.readout(1).val;
 roch2_val  = resp.readout(2).val;
 rofb_val   = resp.readout(3).val;
 roprod_val = resp.readout(4).val;
 roampl_val = resp.readout(5).val;
 roattn_val = resp.readout(6).val; 
%-------------------------------------------------------------------------
%axes('Position', [0.130786 0.904151 0.775 0.063232]);
axes('Position', [0.129214 0.904151 0.775 0.063232]);
col_r1 = black;
col_r2 = black;
col_r3 = black;
col_r4 = black;
axis([0 TSTIM 0 (NO_IP_CHANNELS+1)]);
h = rectangle('position', [0 -2 TSTIM 10]); set(h, 'facecolor', col_shade, 'edgecolor', [1 1 1]); hold on;
h = rectangle('position', [0 9 TSTIM 8]); set(h, 'facecolor', [1 1 1], 'edgecolor', [1 1 1]); hold on;
h = rectangle('position', [0 17 TSTIM 8]); set(h, 'facecolor', col_shade, 'edgecolor', [1 1 1]); hold on;
h = rectangle('position', [0 25 TSTIM 9]); set(h, 'facecolor', [1 1 1], 'edgecolor', [1 1 1]); hold on;
for i = 1:NO_IP_CHANNELS
    if(i <=8), col = col_r1; end;
    if(i>8 & i<=16),col = col_r2;end;
    if(i>16 & i<=24), col = col_r3;end;
    if(i>24), col = col_r4;end;
    st = S.channel(i).data;
    %line([st;st],i+[0.4; -0.4]*ones(1,length(st)),'Color',col,'Linewidth',2.5);
    if(~isempty(st))
        plot(st, i, '.', 'color', col);
        hold on;
    end;
end;
set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', [] , 'YTickLabel', [1 10 20 30]);
[ttl, err] = sprintf('Circuit Response (%s)', txt);
title(ttl, 'fontsize', 14, 'fontweight', 'bold');
title('Input spike trains');

%-------------------------------------------------------------------------
% plots for rates of 4 input channels
%-------------------------------------------------------------------------
% find the times for shading
rateR1 = find_target_rate(S, (1:1:8));
rateR2 = find_target_rate(S, (9:1:16));

timesBox = find_shade_times(rateR1, rateR2);

for i = 1:length(timesBox.box)
    timeHi(2*i-1) = timesBox.box(i).startTime;
    timeHi(2*i) = timesBox.box(i).endTime;
end;
%timeHi = time(find(diff(S.info(1).data) ~=0)) + DT;
%if(mod(length(timeHi), 2) == 1)
%    timeHi = [timeHi TSTIM];
%end
axes('Position', [0.129214 0.804494 0.775 0.063232]); 
% now shade the UP state region
lo = min([rateR1 rateR2 S.info(1).roch1_val S.info(1).roch2_val]);
hi = max([rateR1 rateR2 S.info(1).roch1_val S.info(1).roch2_val]);
 
%for i = 1: length(timeHi)/2
%     h = rectangle('position', [timeHi(2*i -1) lo (timeHi(2*i) - timeHi(2*i-1)) (abs(lo)+hi)]);
%     set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
%     hold on;
%end;
plot(time, rateR1, 'color', col_r1, 'linewidth', 2, 'linestyle', '--'); hold on;
plot(time, rateR2, 'color', col_r2, 'linewidth', 2, 'linestyle', '-.'); hold on;
plot(time, S.info(1).roch1_val, 'k', 'linewidth', 2, 'linestyle', ':'); hold on; 
plot(time, S.info(1).roch2_val, 'k', 'linewidth', 2, 'linestyle', '-'); hold on; 
h = legend('r_1(t)', 'r_2(t)', 'r_3(t)', 'r_4(t)', 1);
set(h, 'fontsize', 9);
set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', []);
title('Firing rates of the 4 input streams');
axis tight;

% subplot 2 - plot the circuit response
axes('Position', [0.128931 0.688431 0.775157 0.0813288]);
make_multi_raster;
axis tight;
title('Circuit response (shown for 100 out of 600 neurons)');
set(gca, 'xticklabel', [], 'box', 'on');

%----------------------------------------------------------------------------
% plot the feedback and partial attractor response
%----------------------------------------------------------------------------
axes('position', [0.128931 0.565865 0.775157 0.0824742]);
% now shade the UP state region
val_plot = max(rofb_val)+5;
lo = min(rofb_val);
hi = val_plot+54;
 
for i = 1: length(timeHi)/2
     h = rectangle('position', [timeHi(2*i -1) lo (timeHi(2*i) - timeHi(2*i-1)) (abs(lo)+hi)]);
     set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
     hold on;
end;
plot(time, rofb_val, 'color', 'k', 'linewidth', 2);hold on;
col = 'k';
for i = 1:NO_READOUTS/4
    st = R{4}.channel(i).data;
    line([st;st],val_plot+[6.5; -6.5]*ones(1,length(st)),'Color',col,'Linewidth',1.5);
    val_plot = val_plot+20;
end;
%title('Target behavior and performance of partial attractor');
title('Target behavior and performance of high-dimensional attractor');
set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', []);
axis([0 TSTIM min(rofb_val) (val_plot+10)]);



axes('Position', [0.129214 0.453283 0.775 0.063232]);
%-------------------------------------------------------------------------
% Plot the readout which computes signal amplification
%-------------------------------------------------------------------------
    
% now shade the UP state region
lo = min([S.info(1).roch1_val S.info(1).roampl_val roampl_val]);
hi = max([S.info(1).roch1_val S.info(1).roampl_val roampl_val]);
 
for i = 1: length(timeHi)/2
     h = rectangle('position', [timeHi(2*i -1) (lo+1) (timeHi(2*i) - timeHi(2*i-1)) (abs(lo)+hi-2)]);
     set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
     hold on;
end;
hold on;
%col_ro1 = [0 153/255 102/255];
col_ro1 = [51 102 51]/255;%'k';
col_ro2 = 'm';
target_ampl = target_att_swtch(S.info(1).roch1_val, timeHi);
plot(time, 2*S.info(1).roch1_val, '-.k', 'linewidth', 2); hold on;
plot(time, S.info(1).roch1_val, ':k', 'linewidth', 2); hold on;
%plot(time, target_ampl, '--k', 'linewidth', 2); hold on;
plot(time, roampl_val, '-k', 'linewidth', 2);                          
h = legend('2 \cdot r_3', 'r_3', 'observed', 1);
set(h, 'fontsize', 9);
                           
% compute the various control measures
control_val.ampl.cc_des_ob = corr_coef(roampl_val, target_ampl);
control_val.ampl.cc_r1_ob = corr_coef(roampl_val, S.info(1).roch1_val);
control_val.ampl.cc_2r1_ob = corr_coef(roampl_val, 2*S.info(1).roch1_val);
control_val.ampl.nrmse_des_ob = nrmse(target_ampl, roampl_val, DT, TSTIM);
control_val.ampl.nrmse_r1_ob = nrmse(S.info(1).roch1_val, roampl_val, DT, TSTIM);
control_val.ampl.nrmse_2r1_ob = nrmse(2*S.info(1).roch1_val, roampl_val, DT, TSTIM);
                            
[ttl, err] = sprintf('State dependent signal amplification');
title(ttl);
axis tight;
axis([0 TSTIM lo hi]);
set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', [], 'TickDir', 'out'); 

%-------------------------------------------------------------------------
% Plot the readout which computes attention switching
%-------------------------------------------------------------------------
axes('Position',[0.129214 0.356007 0.775 0.063232]);
% now shade the UP state region
lo = min(horzcat(abs(S.info(1).roch2_val - S.info(1).roch1_val),...
          abs(S.info(1).roch2_val + S.info(1).roch1_val),...
          S.info(1).roattn_val,...
          roattn_val));
hi = max(horzcat(abs(S.info(1).roch2_val - S.info(1).roch1_val),...
          abs(S.info(1).roch2_val + S.info(1).roch1_val),...
          S.info(1).roattn_val,...
          roattn_val));
 
for i = 1: length(timeHi)/2
    h = rectangle('position', [timeHi(2*i -1) (lo+1) (timeHi(2*i) - timeHi(2*i-1)) (abs(lo)+hi-2)]);
    %set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
%    h = area([timeHi(2*i -1) timeHi(2*i)], [(abs(lo)+hi-1) (abs(lo)+hi-1)]);
    set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
    %set(h, 'Facealpha', 0.3, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
    hold on;
end;
hold on;
target_att = target_sddp(S.info(1).roch1_val, S.info(1).roch2_val, timeHi);
plot(time, abs(S.info(1).roch2_val+S.info(1).roch1_val), '-.k', 'linewidth', 2); hold on;
plot(time, abs(S.info(1).roch2_val - S.info(1).roch1_val), ':k', 'linewidth', 2); hold on;
%plot(time, target_att, '--k', 'linewidth', 2); hold on;
plot(time, roattn_val, '-k', 'linewidth', 2);
%h = legend('|r_3 - r_4|    ', 'r_3 + r_4    ', 'target', 'observed', 1);
h = legend('r_3 + r_4', '|r_3 - r_4|', 'observed', 1);
set(h, 'fontsize', 9);
axis([0 TSTIM lo hi]);
 
% compute the various control measures
control_val.attn.cc_des_ob = corr_coef(roattn_val, target_att);
control_val.attn.cc_diff_ob = corr_coef(roattn_val, abs(S.info(1).roch2_val - S.info(1).roch1_val));
control_val.attn.cc_sum_ob = corr_coef(roattn_val, abs(S.info(1).roch2_val+S.info(1).roch1_val));
control_val.attn.cc_r3_ob = corr_coef(roattn_val, S.info(1).roch1_val);
control_val.attn.cc_r4_ob = corr_coef(roattn_val, S.info(1).roch2_val);
control_val.attn.nrmse_des_ob = nrmse(target_att, roattn_val, DT, TSTIM);
control_val.attn.nrmse_diff_ob = nrmse(abs(S.info(1).roch2_val - S.info(1).roch1_val), roattn_val, DT, TSTIM);
control_val.attn.nrmse_sum_ob = nrmse(abs(S.info(1).roch1_val + S.info(1).roch2_val), roattn_val, DT, TSTIM);
control_val.attn.nrmse_r3_ob = nrmse(S.info(1).roch1_val, roattn_val, DT, TSTIM);
control_val.attn.nrmse_r4_ob = nrmse(S.info(1).roch2_val, roattn_val, DT, TSTIM);
 
%[ttl, err] = sprintf('State dependent differential processing');
[ttl, err] = sprintf('State dependent computational operation');
title(ttl);
set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', [], 'tickdir', 'out');
axis tight; 


%-------------------------------------------------------------------------
% Plot the readout which computes product
%-------------------------------------------------------------------------
axes('Position', [0.129214 0.264459 0.775 0.063232]);
time1 = time(1:10:end);
for ix = 1:length(time1)
  obs_sampl(ix) = roprod_val(find(time == time1(ix)));
end
plot(time, S.info(1).roprod_val, '--k', 'linewidth', 2); hold on;
plot(time, roprod_val, '-k', 'linewidth', 2);hold on;
cc = corr_coef(roprod_val, S.info(1).roprod_val);
mse = nrmse(S.info(1).roprod_val, roprod_val, DT, TSTIM);
%[ttl, err] = sprintf('Computes product of R_3 and R_4( NRMSE = %g , cc = %g )', mse, cc);
%[ttl, err] = sprintf('r3(t) X r4(t) ( NRMSE = %g , cc = %g)', mse, cc);
[ttl, err] = sprintf('Product of r_3(t) and r_4(t)');
set(h, 'fontsize', 8);
title(ttl);
set(gca, 'box', 'on', 'YAxisLocation', 'left');
axis tight;
xlabel('time (s)');
%add_panels_for_power_spec;
%plot_cross_corr;
