
% find 100 random neurons, 20 from each layer to show the spike raster
p = get(nmc, 'pool');
p = p(6);
neuronIdx = p.neuronIdx;

% the neurons that receive r1
r1neuronIdx = neuronIdx(1:125);
idxR1 = randperm(125);
idxR1 = idxR1(1:20);
idxR1 = r1neuronIdx(idxR1);

% the neurons that receive fedback
fbneuronIdx = neuronIdx(126:225);
idxFB = randperm(100);
idxFB = idxFB(1:20);
idxFB = fbneuronIdx(idxFB);

% the neurons that receive r2
r2neuronIdx = neuronIdx(226:350);
idxR2 = randperm(125);
idxR2 = idxR2(1:20);
idxR2 = r2neuronIdx(idxR2);

% the neurons that receive r3
r3neuronIdx = neuronIdx(351:475);
idxR3 = randperm(125);
idxR3 = idxR3(1:20);
idxR3 = r3neuronIdx(idxR3);

% the neurons that receive r4
r4neuronIdx = neuronIdx(476:600);
idxR4 = randperm(125);
idxR4 = idxR4(1:20);
idxR4 = r4neuronIdx(idxR4);


idx.neuronIdx = [idxR1 idxFB idxR2 idxR3 idxR4];

% now make the corresponding channel idx from the response
for i = 1:length(idx.neuronIdx)
    idxCh = find(neuronIdx == idx.neuronIdx(i));
    idx.chIdx(i) = idxCh;
end




for i = 1:length(idx.neuronIdx)
    type = csim('get', idx.neuronIdx(i), 'type');
    
    if(type == 1)
        col = [155 155 155]/255;
    else
        col = [0 0 0];
    end

    st = R{1}.channel(idx.chIdx(i)).data;
    %line([st;st],i+[0.4; -0.4]*ones(1,length(st)),'Color',col,'Linewidth',2.5); 
     if(~isempty(st))
         plot(st, i, '.', 'color', col);
         hold on;
     end   
end
