clear all classes
close all;
 
addpath('../continuous_attractor/');
load_params;
load('../continuous_attractor/results_100/workspace.mat');
  
time = (0:DT:TSTIM);
   
des_line = 'k';
obs_line = 'r';
col_r1 = 'b';
col_r2 = 'g';
col_shade = [215 215 215]/255;

FIX_VAL = 1;
    
for i = 1 :NVALIDATE  
    if(FIX_VAL == 1)
        i = 2;
    end;
    clc;
    clf;
    [fname, err] = sprintf('../continuous_attractor/results_100/w/run%g.mat',i);
    load(fname);
 
    des.channel(1).data = S.info(1).ro1val(1:end-1);   %ro1
    des.channel(2).data = S.info(1).rate2val(1:end-1);   %ro1
    des.channel(3).data = S.info(1).ro2val(1:end-1);   %ro1
    des.channel(4).data = S.info(1).car_switch_val(1:end-1);   %ro1
    des.channel(5).data = S.info(1).carval(1:end-1);   %ro1
 
    %-------------------------------------------------------------------------
    % Plot the inputs
    %-------------------------------------------------------------------------
    axes('Position', [0.0752415 0.905707 0.850498 0.0669975]);
    axis([0 S.info(1).Tstim (-4) (NO_IP_CHANNELS+2)]);
    h = rectangle('position', [0.001 -3.99 (TSTIM-0.002) 12.5]); set(h, 'facecolor', col_shade, 'edgecolor', [1 1 1]); hold on;
    for j = 1:NO_IP_CHANNELS
        st = S.channel(j).data;
        col(j<=NO_IP_CHANNELS/2) = 'k';
        col(j>NO_IP_CHANNELS/2) = 'k';
        %line([st;st],j+[0.3; -0.3]*ones(1,length(st)),...
        %     'Color', col,'Linewidth',1.5);
        if(~isempty(st))
            plot(st, j, '.', 'color', col);
        end
    end;
    title('Circuit inputs');
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', []); 
    
    %-------------------------------------------------------------------------
    % Plot r1(t) and r2(t)
    %-------------------------------------------------------------------------
    axes('Position', [0.0752415 0.806227 0.850498 0.0669975]);
    plot(time(1:end-1), des.channel(1).data, '-k', 'linewidth', 2);hold on;
    plot(time(1:end-1), des.channel(2).data, '--k','linewidth', 2);
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', []);
    title('Input rates');
    h = legend('r_1(t)', 'r_2(t)', 1);
    set(h, 'fontsize', 8);
    axis tight;
    cc = corr_coef(traces.channel(1).data, des.channel(1).data);
    mse = nrmse(des.channel(1).data, traces.channel(1).data, DT, TSTIM);

    
    %-------------------------------------------------------------------------
    % Plot the circuit dynamics
    %-------------------------------------------------------------------------
    axes('Position', [0.0784615 0.631579 0.850769 0.140732]);
    make_cont_attr_rasters;
    axis tight;
    title('Circuit response (shown for 100 out of 600 conductance based HH neurons)');
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', []); 
    
    
    %-------------------------------------------------------------------------
    % Plot CA(t)
    %-------------------------------------------------------------------------
    axes('Position', [0.0752415 0.514474 0.850498 0.0669975]);
    p = get(nmc, 'pool');
    fbNeuronIdx = p(2).neuronIdx;
    avgWt = FBSCALE * find_average_weights(nmc, fbNeuronIdx);
    plot(time(1:end-1), ((des.channel(5).data+BASEVAL) * avgWt)/1e-9, '--k', 'linewidth', 2);
    hold on;
    plot(time(1:end-1), (traces.channel(5).data * avgWt)/1e-9, '-k', 'linewidth', 2);
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', []);
    axis tight;
    ylabel('nA');
    cc = corr_coef(traces.channel(5).data, des.channel(5).data);
    mse = nrmse(des.channel(5).data, traces.channel(5).data, DT, TSTIM);
    %[ttl, err] = sprintf('Activation CA(t) of continuous attractor ( NRMSE = %g , cc = %g)', mse, cc);
    [ttl, err] = sprintf('Activation CA(t) of continuous attractor');
    title(ttl);
    h = legend('target', 'observed'); 
    set(h, 'fontsize', 8);
    
    
    %-------------------------------------------------------------------------
    % Plot switch readout
    %-------------------------------------------------------------------------
    axes('Position', [0.0752415 0.40998 0.850498 0.0669975]);
    lo = min([traces.channel(4).data des.channel(4).data]);
    hi = max([traces.channel(4).data des.channel(4).data]); 

    discreteVal = S.info(1).car_switch_val;
    discreteVal(discreteVal ~=0) = 1;
    timeHi = time(find(diff(discreteVal) ~=0)) + DT;
    if(mod(length(timeHi), 2) == 1)
        timeHi = [timeHi TSTIM];
    end 

    for iRect = 1: length(timeHi)/2
         h = rectangle('position', [timeHi(2*iRect -1) lo (timeHi(2*iRect) - timeHi(2*iRect-1)) (abs(lo)+hi-1)]);
         set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
         hold on;
    end;
    hold on;
    plot(time(1:end-1), traces.channel(4).data, '-k', 'linewidth', 2);
    hold on;
    plot(time(1:end-1), des.channel(4).data, '--k', 'linewidth', 2);hold on;
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', [], 'tickdir', 'out');
    axis tight;
    control_val.swtch.cc_des_ob = corr_coef(traces.channel(4).data, des.channel(4).data);
    control_val.swtch.cc_r2_ob = corr_coef(traces.channel(3).data, des.channel(2).data);
    control_val.swtch.nrmse_des_ob = nrmse(des.channel(4).data, traces.channel(4).data, DT, TSTIM);
    control_val.swtch.nrmse_r2_ob = nrmse(traces.channel(3).data, traces.channel(4).data, DT, TSTIM);
 
    %[ttl, err] = sprintf('Switch of other readout depending on CA(t)');
    [ttl, err] = sprintf('Switch of second readout between r_2(t) and 0, depending on CA(t)');
    title(ttl);
    
    %-------------------------------------------------------------------------
    % Plot r1(t) - CA(t)
    %-------------------------------------------------------------------------
    axes('Position', [0.0721645 0.299572 0.850498 0.0669975]);
    plot(time(1:end-1), traces.channel(3).data, '-k', 'linewidth', 2);
    hold on;
    plot(time(1:end-1), des.channel(3).data, '--k', 'linewidth', 2);
    set(gca, 'box', 'on', 'YAxisLocation', 'left');
    xlabel('time (s)');
    axis tight;
    control_val.cardiff.cc_des_ob = corr_coef(traces.channel(3).data, des.channel(3).data);
    control_val.cardiff.cc_car_ob = corr_coef(traces.channel(3).data, des.channel(5).data);
    control_val.cardiff.cc_r1_ob = corr_coef(traces.channel(3).data, des.channel(1).data);
    control_val.cardiff.nrmse_des_ob = nrmse(des.channel(3).data, traces.channel(3).data, DT, TSTIM);
    control_val.cardiff.nrmse_car_ob = nrmse(des.channel(5).data, traces.channel(3).data, DT, TSTIM);
    control_val.cardiff.nrmse_r1_ob = nrmse(des.channel(1).data, traces.channel(3).data, DT, TSTIM);
    %[ttl, err] = sprintf('Computation of r_1(t) - CA(t) by other readout');
    [ttl, err] = sprintf('Computation of r_1(t) - CA(t) by third readout');
    title(ttl);  
    
    %-------------------------------------------------------------------------
    % Plot stimulus clamping results
    %-------------------------------------------------------------------------
    axes('Position', [0.08 0.0354691 0.290769 0.172769]);
    NEURONIDX = 120;
    for j = 1:10
        [fname, err] = sprintf('../continuous_attractor/results_100/w/run_fixed%g.mat', j);
        load(fname);
        st = R{1}.channel(NEURONIDX).data;
        st(st<0.1) = [];
        line([st;st],(10-j)+[0.4; -0.4]*ones(1,length(st)),...
             'Color', 'k','Linewidth',1.5);
        axis([0.1 S.info(1).Tstim -2 12]);
    end
    xlabel('time (s)');
    ylabel('trial no.');
    title('Response variability to fixed stimulus');
    set(gca, 'box', 'on', 'ytick', [0 4 9], 'yticklabel', [1 5 10]);
    
    %-------------------------------------------------------------------------
    % Plot evidence gathering results
    %-------------------------------------------------------------------------
    axes('Position', [0.445385 0.0411899 0.363077 0.173913]);
    timeEvid = (0:2e-3:0.5);
    leg_arr = [];
    line_st = {'-k', '-k', '-k', '-k', '-k', '-k', '-k', '-k'}
    data = [];
    load('../evidence_gathering_hh_neuron/results/workspace.mat');
    p = get(nmc, 'pool');
    fbNeuronIdx = p(2).neuronIdx;
    avgWt = find_average_weights(nmc, fbNeuronIdx);
    for iEvid = 1 :8
        [fname, err] = sprintf('../evidence_gathering_hh_neuron/results/w/run%g.mat',iEvid);
        load(fname);
     
        des.channel(1).data = S.info(1).carval(1:end-1);   %ro1
     
        data = [data; (avgWt * traces.channel(1).data)/1e-9];
    
        % car
        if(S.info(1).diff == 10)
            col = 'r';
        end;
        if(S.info(1).diff == 30)
            col = 'm';
        end
        if(S.info(1).diff == 50)
            col = 'g';
        end
        if(S.info(1).diff == 70)
            col = 'b';
        end;
        if(S.info(1).isUp ==1)
            h = plot(timeEvid(1:end-1), (avgWt* traces.channel(1).data)/1e-9, line_st{iEvid}, ...
                'linewidth', 0.5);
        else
            h = plot(timeEvid(1:end-1), (avgWt * traces.channel(1).data)/1e-9, line_st{iEvid}, ...
                'linewidth', 0.5, 'linestyle', '-');
        end;
        %if(i <= NVALIDATE/2)
            leg_arr = [leg_arr h];
        %end
        hold on;
        xlabel('time (s)');
        ylabel('nA');
        title('Integration of evidence by continuous attractor');
    end;
    h1 = plot(0,0,'ow');hold on;
    h2 = plot(0,0,'ow');
    leg_arr = [h1 h2 leg_arr(4:-1:1) leg_arr(5:1:8)];
    %legend(leg_arr, 'r_1 -r_2 (Hz)', 'dummy', '10', '30', '50', '70', '-10', '-30', '-50', '-70', 1); 
    %h = legend(leg_arr, 'r_1 -r_2  (Hz)', 'dummy', '70', '50', '30', '10', '-10 ', '-30 ', '-50 ', '-70 ', 1); 
    hold on;
    %time1 = timeEvid(200);
    %time1 = [0.3 0.4 0.38 0.4 0.25 0.32 0.15 0.28];
    %time1 = [0.150 0.450 0.250 0.350 0.150 0.450 0.250 0.350];
    %time1 = [0.3 0.38 0.25 0.15 0.4 0.4 0.30 0.45];
    time1 = [0.3 0.25 0.37 0.42 0.4 0.38 0.3 0.47];
    
    %time1 = [0.3 0.38 0.25 0.15 0.4 0.4 0.30 0.45];
    mark_st = {'dk', 'sk', 'hk', 'ok', 'vk', '^k', '<k', '>k'};
    harr = [];
    idxdata = 1;
    for idxPlot = 1:8
        dataPlot = data(idxPlot,:);
        dataPlot = dataPlot(find(timeEvid == time1(idxPlot)));
        hid = plot(time1(idxPlot), dataPlot, mark_st{idxPlot}, 'markersize', 8, 'markerfacecolor', 'k');
        harr = [harr hid];
        hold on;
    end
    axis tight;
    h_new = [h1 h2 harr(4:-1:1) harr(5:8)];
    h = legend(h_new, 'r_1 -r_2  (Hz)', 'dummy', '70', '50', '30', '10', '-10 ', '-30 ', '-50 ', '-70 ', 1); 
    set(h, 'fontsize', 9);
    clear des traces;

    R = input('\n\nLabels (Enter - No | Anyotherkey - Yes)?');
    if(~isempty(R))
        axes('position', [0 0 1 1], 'visible', 'off');
        gtext('A', 'fontweight', 'bold', 'fontsize', 12);
        gtext('B', 'fontweight', 'bold', 'fontsize', 12);
        gtext('C', 'fontweight', 'bold', 'fontsize', 12);
        gtext('D', 'fontweight', 'bold', 'fontsize', 12);
        gtext('E', 'fontweight', 'bold', 'fontsize', 12);
        gtext('F', 'fontweight', 'bold', 'fontsize', 12);
        gtext('G', 'fontweight', 'bold', 'fontsize', 12);
        gtext('H', 'fontweight', 'bold', 'fontsize', 12);
        gtext('r_1 - r_2 (Hz)', 'fontsize', 8);
        anykey;
    end; 
end;
