clear all classes
close all;

addpath('../evidence_gathering_hh_neuron/');
load_params;

time = (0:DT:TSTIM);

des_line = [0.8 0 0];
obs_line = [0 0.6 0]; 
col_r1 = 'r';
col_r2 = 'b';

figure;
col_r1 = 'r';
col_r2 = 'b';
leg_arr = [];

for i = 1 :NVALIDATE
    [fname, err] = sprintf('../evidence_gathering_hh_neuron/results/w/run%g.mat',i);
    load(fname);

    des.channel(1).data = S.info(1).carval(1:end-1);   %ro1

%    if(i == 2)
%        %subplot(3,1,1);
%        for j = 1:NO_IP_CHANNELS
%            col(j<=8) = col_r1;
%            col(j>8) = col_r2;
%            st = S.channel(j).data;
%            line([st;st],j+[0.3; -0.3]*ones(1,length(st)),'Color',col,'Linewidth',1.5);
%            axis([0 TSTIM (-2) (NO_IP_CHANNELS+1)]);
%            set(gca, 'xticklabel', []);
%        end; 
%        title('Circuit inputs');
%
%        %subplot(3,1,2);
%        plot(time(1:end-1), traces.channel(1).data, 'r', 'linewidth', 2);
%        hold on;
%        plot(time(1:end-1), des.channel(1).data, 'b', 'linewidth', 2);
%        legend('observed', 'target');
%        title('Results from a validation run');
%        set(gca, 'xticklabel', []);
%    end;

   %subplot(3,1,3);
   % car
   if(S.info(1).diff == 10)
        col = 'r';
   end;
   if(S.info(1).diff == 30)
        col = 'm';
   end
   if(S.info(1).diff == 50)
        col = 'g';
   end
   if(S.info(1).diff == 70)
        col = 'b'; 
   end;
    if(S.info(1).isUp ==1)
        h = plot(time(1:end-1), traces.channel(1).data, 'color', col, ...
	    'linewidth', 2);
    else
        h = plot(time(1:end-1), traces.channel(1).data, 'color', col, ...
	    'linewidth', 2, 'linestyle', '--');
    end;
    %if(i <= NVALIDATE/2)
        leg_arr = [leg_arr h];
    %end
    hold on;
    xlabel('time (s)');
    title('Integration of evidence by continuous attractor');
end;   
%subplot(3,1,3);
h = plot(0,0,'ow');
leg_arr = [h leg_arr];
legend(leg_arr, 'r_1 - r_2 (Hz)', '10', '30', '50', '70', '-10', '-30', '-50', '-70', 2);

