clear all classes;
close all;

addpath('../cont_attr_evidence_08_03_05/');
load_params;

figure(1);

val_des = [];
val_obs = [];
for i = 1:NVALIDATE
    [fname, err] = sprintf('../cont_attr_evidence_08_03_05/results/w/run%g.mat', i);
    load(fname);
    val_des = vertcat(val_des, S.info(1).carval(1:end-1));
    val_obs = vertcat(val_obs, traces.channel(1).data);
end;
time = (0:DT:TSTIM);
t = (0:20e-3:0.5);
a = ismember(time, t);
idx = find(a == 1);

avg_val_des = mean(val_des);
avg_val_obs = mean(val_obs);
std_val_des = std(val_des);
std_val_obs = std(val_obs);

subplot(3,1,1);
plot(time(1:end-1), avg_val_des, 'b'); hold on;
e = errorbar(t(1:end-1), avg_val_des(idx(1:end-1)), std_val_des(idx(1:end-1)), 'b');
set(e(2), 'visible', 'off');
set(gca, 'box', 'off', 'YAxisLocation', 'left', 'XTickLabel', []);
title('Statistics of the desired signal');
axis tight;

subplot(3,1,2);
plot(time(1:end-1), avg_val_obs, 'r'); hold on;
e = errorbar(t(1:end-1), avg_val_obs(idx(1:end-1)), std_val_obs(idx(1:end-1)), 'r');
set(e(2), 'visible', 'off');
set(gca, 'box', 'off', 'YAxisLocation', 'left', 'XTickLabel', []);
title('Statistics of the observed signal');
axis tight;

subplot(3,1,3);
for i = 1:NVALIDATE
    plot(time(1:end-1), val_obs(i,:), 'r'); hold on;
end;
title('The observed signals');
xlabel('time (s)');
axis tight;

gtext('A', 'fontweight', 'bold', 'fontsize', 12);
gtext('B', 'fontweight', 'bold', 'fontsize', 12);
gtext('C', 'fontweight', 'bold', 'fontsize', 12);    
     
