function [fp_matrix, fn_matrix, opt_thrsh] = perf_measure()
%-------------------------------------------------------------------------
% Desc - Caluclates a performance matrix. Each column of the matrix is the
%        performance of the system for one particular threshold value.
%
%        Definitions:
%        1) False Positives - When desired is 0, and observed is 1
%        2) False Negatives - When desired is 1, and observed is 0.
%
%        (c), 2005, Prashant Joshi (joshi@igi.tugraz.at)
%-------------------------------------------------------------------------
addpath('../multi_layered_lsqnonneg');
load_params;
global THRSH_VAL DT TSTIM NVALIDATE KERNEL_SIZE NO_FB_CHANNELS
load('../multi_layered_lsqnonneg/results/workspace.mat');

PLOT3 =1;

TOTAL_POINTS = length(0:DT:TSTIM);
fp_matrix = zeros(NVALIDATE, length(THRSH_VAL));
fn_matrix = zeros(NVALIDATE, length(THRSH_VAL));
for i = 1:NVALIDATE
    [fname, err] = sprintf('../multi_layered_lsqnonneg/results/run%g.mat', i);
    load(fname); % loads the params from this validation run

    % find the desired value
    des_val = make_target(S);

    % create the spike trains from the response of spiking readouts
    Stim = R{4};
    % calculate the mean firing rate
    resp = readout_resp(trained_readouts,R{1}, S,{ 'response2states' [0:DT:TSTIM] });
    mfr   = resp.readout(3).val;
    %mfr = sumofrates(Stim, KERNEL_SIZE, DT, TSTIM)./NO_FB_CHANNELS;
    for j = 1:length(THRSH_VAL)
        % calculate the observed value for this threshold
        obs_val = mfr;
        obs_val(obs_val <THRSH_VAL(j)) = 0;
        obs_val(obs_val ~=0) = 1;
        fp = find(des_val == 0 & obs_val == 1);
        fp(isempty(fp)) = 0;
        fn = find(des_val == 1 & obs_val == 0);
        fn(isempty(fn)) = 0;
        fp = length(fp)/TOTAL_POINTS;
        fn = length(fn)/TOTAL_POINTS;
        fp_matrix(i,j) = fp;
        fn_matrix(i,j) = fn;
    end
end;

mean_fp = mean(fp_matrix);
mean_fn = mean(fn_matrix);

% now calculate the optimum threshold (the threshold for which the sum of 
% false positive and false negative is minimum)

sum_err = mean_fp + mean_fn;
keyboard;
idx = find(sum_err == min(sum_err));
idx = idx(1);
opt_thrsh = THRSH_VAL(idx);;
keyboard;
if PLOT3 == 1
    %subplot(2,3,1);
    axes('Position', [0.0943    0.7648    0.3045    0.1825]);
    
    imagesc(fp_matrix);
    colorbar;
    set(gca, 'xticklabel', (10:10:60));
    xlabel('Threshold frequency');
    ylabel('Validation run');

    %subplot(2,3,2);
    axes('Position', [0.5147    0.7648    0.3045    0.1825]);
    imagesc(fn_matrix);
    colorbar;
    set(gca, 'xticklabel', (10:10:60));
    xlabel('Threshold frequency');
    ylabel('Validation run');

    %subplot(2,3,3);
    axes('Position', [0.0989    0.3650    0.7141    0.3149]);
    plot(mean_fp, mean_fn, 'k-', 'linewidth', 2 );%, mean_fp, mean_fn, 'ro', 'linewidth', 2);
    hold on;
    plot(mean_fp(idx), mean_fn(idx), 'rO','linewidth', 2  );
    xlabel('Fraction of false positives');
    ylabel('Fraction of false Negatives');
    [ttl, err] = sprintf('Optimum threshold = %g Hz',opt_thrsh);
    title(ttl, 'fontsize', 12, 'fontweight', 'bold');

    gtext('A', 'fontweight', 'bold', 'fontsize', 12);
    gtext('B', 'fontweight', 'bold', 'fontsize', 12);
    gtext('C', 'fontweight', 'bold', 'fontsize', 12);
        
                    
else
    plot(mean_fp, mean_fn, 'k-', 'linewidth', 2 );%, mean_fp, mean_fn, 'ro', 'linewidth', 2); 
    hold on;
    plot(mean_fp(idx), mean_fn(idx), 'rO','linewidth', 2  );
    xlabel('Fraction of false positives');
    ylabel('Fraction of false Negatives');
    [ttl, err] = sprintf('Total Validation Runs = %g, Optimum Threshold = %g Hz', NVALIDATE, opt_thrsh);
    title(ttl, 'fontsize', 14, 'fontweight', 'bold');
    axis([0 0.7 0 0.7]);
end;
