clear all classes;
close all;

addpath('../multilsq_dynsta/');
%addpath('../multi_new_v1/');
load_params;

load('../multilsq_dynsta/results/workspace.mat');
%load('../multi_new_v1/results/workspace.mat');

FIXED_STIMULUS = 0;

for idx_res = 1:NVALIDATE
    clc;
    if(FIXED_STIMULUS == 1)
        idx_res = 2;
    end;
    [fname, err] = sprintf('../multilsq_dynsta/results/run%g.mat', idx_res);
    %[fname, err] = sprintf('../multi_new_v1/results/run%g.mat', idx_res);
    load(fname); 

    if(FIXED_STIMULUS == 1)
        S = hand_made_stimulus(S);
        run_closed_loop;
        reset(nmc);
        R = simulate(nmc, TSTIM, S); 
    end;
    
    %-----------------------------------------------------------------------
    % this plots the figure 1 (performance of partial attractors)
    figure(1);clf;spiking_readout_plot(S,R, trained_readouts, 'Validation', nmc);
    %-----------------------------------------------------------------------
    % this plots the figure 2 (performance of linear readouts)
%    figure(2);clf;cla;control_val = linear_readout_plot(S,R, trained_readouts, 'Validation');
%
%    % now print the control measures
%    fprintf('\n\n-----------------------------------------\n');
%    fprintf('Control Measures for Signal Amplification\n');
%    fprintf('-----------------------------------------\n');
%    fprintf('corr(target, observed) = %g\tcorr(r3, observed) = %g\tcorr(2.r3, observed) = %g\n',...
%             control_val.ampl.cc_des_ob, ...
%	     control_val.ampl.cc_r1_ob, ...
%	     control_val.ampl.cc_2r1_ob);
%    fprintf('nrmse(target, observed) = %g\tnrmse(r3, observed) = %g\tnrmse(2.r3, observed) = %g\n',...
%             control_val.ampl.nrmse_des_ob, ...
%	     control_val.ampl.nrmse_r1_ob, ...
%	     control_val.ampl.nrmse_2r1_ob);
%    
%    fprintf('\n\n-----------------------------------------\n');
%    fprintf('Control Measures for Attention Switching\n');
%    fprintf('-----------------------------------------\n');
%    fprintf('corr(target, observed) = %g\tcorr(|r3 - r4|, observed) = %g\tcorr(|r3 + r4|, observed) = %g\tcorr(r3, observed) = %g\tcorr(r4,observed) = %g\n',...
%             control_val.attn.cc_des_ob, ...
%	     control_val.attn.cc_diff_ob, ...
%	     control_val.attn.cc_sum_ob,...
%             control_val.attn.cc_r3_ob,...
%             control_val.attn.cc_r4_ob);
%    fprintf('nrmse(target, observed) = %g\tnrmse(|r3 - r4|, observed) = %g\tnrmse(|r3 + r4|, observed) = %g\tnrmse(r3, observed) = %g\tnrmse(r4, observed) = %g\n',...
%             control_val.attn.nrmse_des_ob, ...
%	     control_val.attn.nrmse_diff_ob, ...
%	     control_val.attn.nrmse_sum_ob,...
%             control_val.attn.nrmse_r3_ob,...
%             control_val.attn.nrmse_r4_ob);

    % plot the power spectrum
    %figure(3); clf; plot_power_spec(R);

    ur = input('\n\nLabels (Enter - No | Anyotherkey - Yes)?');
    if(~isempty(ur))
        figure(1);
        %add_panels_for_power_spec;
        %plot_cross_corr;
        %keyboard;
        %gtext('Power spectrum for the feedback layer', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('Power spectrum for entire circuit', 'fontweight', 'bold', 'fontsize', 12);
        gtext('A', 'fontweight', 'bold', 'fontsize', 12);
        gtext('B', 'fontweight', 'bold', 'fontsize', 12);
        gtext('C', 'fontweight', 'bold', 'fontsize', 12);
        gtext('D', 'fontweight', 'bold', 'fontsize', 12);
        gtext('E', 'fontweight', 'bold', 'fontsize', 12);
        gtext('F', 'fontweight', 'bold', 'fontsize', 12);
        gtext('G', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('H', 'fontweight', 'bold', 'fontsize', 12);

        %figure(2);
        %gtext('A', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('B', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('C', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('D', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('E', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('F', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('G', 'fontweight', 'bold', 'fontsize', 12);

        %figure(3);
        %compare_power_spec
        %gtext('A', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('B', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('C', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('D', 'fontweight', 'bold', 'fontsize', 12);
        %gtext('E', 'fontweight', 'bold', 'fontsize', 12);
        anykey;
    end; 

    %-----------------------------------------------------------------------
    % this plots the figure 3 (performance of linear readouts in open loop)
    %figure(3); clf;
    %best_example = plot_readouts(trained_readouts,V.test_response,V.test_stimuli,...
    %                     { 'response2states' [0:DT:TSTIM] {'spikes2exp' 0.03}} );
    %anykey;
end;
