%-------------------------------------------------------------------------
% Desc - Does a mfr analysis to study the impact of converting dynamic
%        synapses in the circuit to static ones.
%-------------------------------------------------------------------------

    clear all classes;
    close all;
    addpath('../hh_neuron_switch_dynamic_synapses');
    load_params;

    global NVALIDATE;
    
    mfr_dyn = zeros(1,600);
    mfr_sta = zeros(1,600);
    
    for i = 1: NVALIDATE
        [fn, e] = sprintf('../hh_neuron_switch_dynamic_synapses/results/w/run%g.mat', i);
        load(fn);
        for j = 1:600
            mfr_dyn(j) = mfr_dyn(j) + length(R{1}.channel(j).data)/R{1}.Tsim;
        end;
        [fn, e] = sprintf('../hh_neuron_switch_static_synapses/results/w/run%g.mat', i);
        load(fn);
        for j = 1:600
            mfr_sta(j) = mfr_sta(j) + length(R{1}.channel(j).data)/R{1}.Tsim;
        end;
    end
    mfr_dyn = mfr_dyn/NVALIDATE;
    mfr_sta = mfr_sta/NVALIDATE;

    subplot(211);
    hist(mfr_dyn, 50);
    title('mean firing rate over 100 validation runs for the circuit with dynamic synapses');
    subplot(212);
    hist(mfr_sta, 50);
    title('mean firing rate over 100 validation runs for the circuit with static synapses');

