function stim = hand_made_stimulus(S)
global DT TSTIM NO_IP_CHANNELS

time = (0:DT:TSTIM);

timeUP = time(find(diff(S.info(1).data) ~=0)) + DT;
if(mod(length(timeUP), 2) == 1)
    timeUP = [timeUP TSTIM];
end     

rateFixed = 30 + 10* rand(size(time));
bg1 = rate2spikes(rateFixed, DT, 16, TSTIM);

stim = S;
for i = 1:length(timeUP)/2
    timeStart = timeUP(2*i -1) - 70e-3;
    timeStart(timeStart <0) = 0;
    %timeEnd   = timeUP(2*i);
    timeEnd = timeStart + 250e-3;
    timeEnd(timeEnd > TSTIM) = TSTIM;
    for j = 17:NO_IP_CHANNELS
        data = S.channel(j).data;
        data(data >= timeStart & data <=timeEnd) = [];
        NewData = bg1{j-16};
        NewData(NewData <= timeStart & NewData >=timeEnd) = [];
        data = sort([data NewData]);
        stim.channel(j).data = data;
    end
end

stim.info(1).roch1_val = values_for_roch1(stim);
stim.info(1).roch2_val = values_for_roch2(stim);
stim.info(1).rofb_val = values_for_rofb(stim);
stim.info(1).roprod_val = values_for_roprod(stim);
stim.info(1).roampl_val = values_for_roampl(stim);
stim.info(1).roattn_val = values_for_roattn(stim); 
