function [upTime, downTime] = find_times(data, winSize, waitTime, dt, Tstim)
 
time = (0:dt:Tstim);
timeHi = time(find(diff(data) ~=0)) + dt;
if(mod(length(timeHi), 2) == 1)
    timeHi = [timeHi Tstim];
end

% now find the down times
downTimeStart = timeHi(2:2:end) + dt;
downTimeStart(downTimeStart > Tstim) = [];
downTimeEnd   = timeHi(3:2:end) -dt;
downTimeEnd(downTimeEnd < 0) = [];

% check if upTime started after 0
if(timeHi(1) > 0)
    downTimeStart = [0 downTimeStart];
    downTimeEnd   = [(timeHi(1) -dt) downTimeEnd];
end
% check if upTime ended before Tstim
if(timeHi(end) ~= Tstim)
   %downTimeStart = [downTimeStart (timeHi(end)+dt)];
   downTimeEnd   = [downTimeEnd Tstim];
end

timeLo = [];

for i = 1:length(downTimeStart)
    timeLo = [timeLo downTimeStart(i) downTimeEnd(i)];
end

% now find the possible time-zones for upTime
diffUpTime = [];
for i = 1:length(timeHi)/2
    diffUpTime = [diffUpTime (timeHi(2*i) - timeHi(2*i -1))];
end;
idx = find(diffUpTime == max(diffUpTime));
upTime = timeHi(2*idx-1);
if(max(diffUpTime) > (winSize+waitTime))
    upTime = upTime + waitTime;
end;

% now find the possible time-zones for downTime
diffLoTime = [];
for i = 1:length(timeLo)/2
    diffLoTime = [diffLoTime (timeLo(2*i) - timeLo(2*i -1))];
end;
idx = find(diffLoTime == max(diffLoTime));
downTime = timeLo(2*idx -1);
if(max(diffLoTime) > (winSize+waitTime))
    downTime = downTime + waitTime;
end;
