function timesBox = find_shade_times(rate1, rate2)

global DT TSTIM
time = (0:DT:TSTIM);

clampR1 = rate1;
clampR1(clampR1 < 30) = 0;
clampR1(clampR1 ~=0) = 1;

clampR2 = rate2;
clampR2(clampR2 < 30) = 0;
clampR2(clampR2 ~=0) = 1;

timeStart = time(find(diff(clampR1) ~=0)) + DT;
timeStart = timeStart(1:2:end);
timeEnd = time(find(diff(clampR2) ~=0)) + DT;
timeEnd = timeEnd(1:2:end);

if(length(timeStart) > length(timeEnd))
    timeEnd = [timeEnd TSTIM];
end
timesBox = [];
for iTimes = 1:length(timeStart)
    timesBox.box(iTimes).startTime = timeStart(iTimes);
    timesBox.box(iTimes).endTime = timeEnd(iTimes);
end;
