%-------------------------------------------------------------------------
% Desc - Does an NRMSE analysis of static and dynamic circuits
%-------------------------------------------------------------------------

    clear all classes;
    close all;
    addpath('../continuous_attractor');
    load_params;

    global NVALIDATE;
    
    err_500 = []; 
    err_400  = [];
    err_300 = [];
    err_200  = []; 
    err_150  = [];
    err_125  = [];
    err_100 = [];
    err_75 = [];
    err_50 = [];
    err_25  = [];
    err_10  = [];
    err_0 = [];

    subplots = 1;
    target = [];
    obs = [];
    time = DT:DT:TSTIM;
    for i = 1: NVALIDATE

        % 500% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_500/w/run%g.mat', i);
        load(fn);
        err_500(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_500(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_500(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_500(1,i))), err_500(1,i) = 0, end;
        if(isnan(err_500(2,i))), err_500(2,i) = 0, end;
        if(isnan(err_500(3,i))), err_500(3,i) = 0, end;
        
        % 400% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_400/w/run%g.mat', i);
        load(fn);
        err_400(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_400(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_400(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_400(1,i))), err_400(1,i) = 0, end;
        if(isnan(err_400(2,i))), err_400(2,i) = 0, end;
        if(isnan(err_400(3,i))), err_400(3,i) = 0, end;

        % 300% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_300/w/run%g.mat', i);
        load(fn);
        err_300(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_300(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_300(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_300(1,i))), err_300(1,i) = 0, end;
        if(isnan(err_300(2,i))), err_300(2,i) = 0, end;
        if(isnan(err_300(3,i))), err_300(3,i) = 0, end;

        % 200% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_200/w/run%g.mat', i);
        load(fn);
        err_200(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_200(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_200(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_200(1,i))), err_200(1,i) = 0, end;
        if(isnan(err_200(2,i))), err_200(2,i) = 0, end;
        if(isnan(err_200(3,i))), err_200(3,i) = 0, end;
        
        % 150% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_150/w/run%g.mat', i);
        load(fn);
        err_150(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_150(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_150(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_150(1,i))), err_150(1,i) = 0, end;
        if(isnan(err_150(2,i))), err_150(2,i) = 0, end;
        if(isnan(err_150(3,i))), err_150(3,i) = 0, end;

        % 125% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_125/w/run%g.mat', i);
        load(fn);
        err_125(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_125(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_125(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_125(1,i))), err_125(1,i) = 0, end;
        if(isnan(err_125(2,i))), err_125(2,i) = 0, end;
        if(isnan(err_125(3,i))), err_125(3,i) = 0, end;

        % 100% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_100/w/run%g.mat', i);
        load(fn);
        err_100(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_100(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_100(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_100(1,i))), err_100(1,i) = 0, end;
        if(isnan(err_100(2,i))), err_100(2,i) = 0, end;
        if(isnan(err_100(3,i))), err_100(3,i) = 0, end;

        % 75% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_75/w/run%g.mat', i);
        load(fn);
        err_75(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_75(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_75(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_75(1,i))), err_75(1,i) = 0, end;
        if(isnan(err_75(2,i))), err_75(2,i) = 0, end;
        if(isnan(err_75(3,i))), err_75(3,i) = 0, end;

        % 50% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_50/w/run%g.mat', i);
        load(fn);
        err_50(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_50(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_50(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_50(1,i))), err_50(1,i) = 0, end;
        if(isnan(err_50(2,i))), err_50(2,i) = 0, end;
        if(isnan(err_50(3,i))), err_50(3,i) = 0, end;

        % 25% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_25/w/run%g.mat', i);
        load(fn);
        err_25(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_25(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_25(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_25(1,i))), err_25(1,i) = 0, end;
        if(isnan(err_25(2,i))), err_25(2,i) = 0, end;
        if(isnan(err_25(3,i))), err_25(3,i) = 0, end;

        % 10% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_10/w/run%g.mat', i);
        load(fn);
        err_10(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_10(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_10(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_10(1,i))), err_10(1,i) = 0, end;
        if(isnan(err_10(2,i))), err_10(2,i) = 0, end;
        if(isnan(err_10(3,i))), err_10(3,i) = 0, end;

        % 0% connectivity
        [fn, e] = sprintf('../continuous_attractor/results_0/w/run%g.mat', i);
        load(fn);
        err_0(1,i) = corr_coef((S.info(1).carval(1:end-1)+0.65), traces.channel(5).data);
        err_0(2,i) = corr_coef(S.info(1).car_switch_val(1:end-1), traces.channel(4).data);
        err_0(3,i) = corr_coef(S.info(1).ro2val(1:end-1), traces.channel(3).data);
        if(isnan(err_0(1,i))), err_0(1,i) = 0, end;
        if(isnan(err_0(2,i))), err_0(2,i) = 0, end;
        if(isnan(err_0(3,i))), err_0(3,i) = 0, end;
    end
    
    % make plot with errorbars
    for readouts = 1:3
        x.channel(readouts).data = [0 2 5 10 15 20 25 30 40 60 80 100]*5;
        y.channel(readouts).data = [mean(err_0(readouts,:)) mean(err_10(readouts,:))...
                                    mean(err_25(readouts,:)) mean(err_50(readouts,:)) ...
                                    mean(err_75(readouts,:)) mean(err_100(readouts,:))...
                                    mean(err_125(readouts,:)) mean(err_150(readouts,:)) ...
                                    mean(err_200(readouts,:)) mean(err_300(readouts,:)) ...
                                    mean(err_400(readouts,:)) mean(err_500(readouts,:))];
        err.channel(readouts).data = [std(err_0(readouts,:)) std(err_10(readouts,:))...
                                    std(err_25(readouts,:)) std(err_0(readouts,:)) ...
                                    std(err_75(readouts,:)) std(err_100(readouts,:))...
                                    std(err_125(readouts,:)) std(err_150(readouts,:)) ...
                                    std(err_200(readouts,:)) std(err_300(readouts,:))...
                                    std(err_400(readouts,:)) std(err_500(readouts,:))]./10;
    end

if(subplots == 0)
    figure(1);
    errorbar(x.channel(1).data,y.channel(1).data,err.channel(1).data, 'k');
    xlabel('feedback strength (%)');
    ylabel('correlation');
else
    figure(1);

    load('../continuous_attractor/results_100/workspace.mat');
    load('../continuous_attractor/results_0/w/run1.mat');
    subplot(4,1,1);
    p = get(nmc, 'pool');
    fbNeuronIdx = p(2).neuronIdx;
    avgWt = find_average_weights(nmc, fbNeuronIdx);
    plot(time, ((S.info(1).carval(1:end-1)+BASEVAL) * avgWt)/1e-9, 'k', 'linewidth', 2);
    hold on;
    plot(time, (traces.channel(5).data * avgWt)/1e-9, 'r', 'linewidth', 2);
    hold on;
    legend('target', 'observed', 4);
    xlabel('time (s)');
    ylabel('nA');
    title('Typical temporal evolution of continuous attractor readout for 0% feedback');


    subplot(4,1,2);
    errorbar(x.channel(1).data,y.channel(1).data,err.channel(1).data, 'k');
    text(-90, 0.95, 'Performance of continuous attractor readout (shown in panel D of figure 4)');
    xlabel('feedback strength (%)');
    ylabel('correlation');
    
    subplot(4,1,3);
    errorbar(x.channel(2).data,y.channel(2).data,err.channel(2).data, 'k');
    text(-90, 0.95, 'Performance of switching readout (shown in panel E of figure 4)');
    xlabel('feedback strength (%)');
    ylabel('correlation');
    
    subplot(4,1,4);
    errorbar(x.channel(3).data,y.channel(3).data,err.channel(3).data, 'k');
    text(-90, 0.95, 'Performance of third readout (shown in panel F of figure 4)');
    xlabel('feedback strength (%)');
    ylabel('correlation');
end
R = input('\n\nLabels (Enter - No | Anyotherkey - Yes)?');
if(~isempty(R))
  gtext('A', 'fontweight', 'bold', 'fontsize', 12);
  gtext('B', 'fontweight', 'bold', 'fontsize', 12);
  gtext('C', 'fontweight', 'bold', 'fontsize', 12);
  gtext('D', 'fontweight', 'bold', 'fontsize', 12);
end

