clear all classes
close all;
 

%addpath('../hh_neuron_switch/');
addpath('../continuous_attractor/');

load_params;
%load('../hh_neuron_switch/results/workspace.mat');
load('../continuous_attractor/results_100/workspace.mat');
global FBSCALE
  
time = (0:DT:TSTIM);
   
des_line = 'k';
obs_line = 'r';
col_r1 = 'b';
col_r2 = 'g';
col_shade = [102 255 254]/255;

FIX_VAL = 1;
    
for i = 1 :NVALIDATE  
    if(FIX_VAL == 1)
        i = 13;
    end
    clc;
    clf;
    %[fname, err] = sprintf('../hh_neuron_switch/results/w/run%g.mat',i);
    [fname, err] = sprintf('../continuous_attractor/results_100/w/run%g.mat',i);
    load(fname);
 
    des.channel(1).data = S.info(1).ro1val(1:end-1);   %ro1
    des.channel(2).data = S.info(1).rate2val(1:end-1);   %ro1
    des.channel(3).data = S.info(1).ro2val(1:end-1);   %ro1
    des.channel(4).data = S.info(1).car_switch_val(1:end-1);   %ro1
    des.channel(5).data = S.info(1).carval(1:end-1);   %ro1
 
    %-------------------------------------------------------------------------
    % Plot the inputs
    %-------------------------------------------------------------------------
    axes('Position', [0.0752415 0.905707 0.850498 0.0669975]);
    for j = 1:NO_IP_CHANNELS
        st = S.channel(j).data;
        col(j<=NO_IP_CHANNELS/2) = col_r1;
        col(j>NO_IP_CHANNELS/2) = col_r2;
        line([st;st],j+[0.3; -0.3]*ones(1,length(st)),...
             'Color', col,'Linewidth',1.5);
        axis([0 S.info(1).Tstim (-4) (NO_IP_CHANNELS+2)]);
    end;
    title('Circuit inputs');
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', []); 
    
    %-------------------------------------------------------------------------
    % Plot r1(t) and r2(t)
    %-------------------------------------------------------------------------
    axes('Position', [0.0752415 0.806227 0.850498 0.0669975]);
    plot(time(1:end-1), des.channel(1).data, 'color', col_r1, 'linewidth', 2);hold on;
    plot(time(1:end-1), des.channel(2).data, 'color', col_r2, 'linewidth', 2);
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', []);
    title('Input rates');
    h = legend('r_1(t)', 'r_2(t)', 1);
    set(h, 'fontsize', 9);
    axis tight;
    cc = corr_coef(traces.channel(1).data, des.channel(1).data);
    mse = nrmse(des.channel(1).data, traces.channel(1).data, DT, TSTIM);

    
    %-------------------------------------------------------------------------
    % Plot the circuit statics
    %-------------------------------------------------------------------------
    axes('Position', [0.0784615 0.631579 0.850769 0.140732]);
    load('../continuous_attractor/results_100/workspace.mat');
    make_cont_attr_rasters;
    axis tight;
    title('Circuit response (shown for 100 out of 600 conductance based HH neurons');
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', []); 
    
    
    %-------------------------------------------------------------------------
    % Plot CA(t)
    %-------------------------------------------------------------------------
    axes('Position', [0.0752415 0.514474 0.850498 0.0669975]);
    p = get(nmc, 'pool');
    fbNeuronIdx = p(2).neuronIdx;
    avgWt = FBSCALE * find_average_weights(nmc, fbNeuronIdx);
    plot(time(1:end-1), ((des.channel(5).data+BASEVAL) * avgWt)/1e-9, 'color', des_line, 'linewidth', 2);
    hold on;
    plot(time(1:end-1), (traces.channel(5).data * avgWt)/1e-9, 'color', obs_line, 'linewidth', 2);
    hold on;
    % block
    %h = line([0 TSTIM], (0.3 * avgWt*[1 1])*1e9);
    %set(h, 'linestyle', '--');
    % block
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', [],...
        'ytick', [0 0.4 0.8 1.2 1.6], 'yticklabel', [0 0.4 0.8 1.2 1.6]);
    axis tight;
    ylabel('nA');
    cc = corr_coef(traces.channel(5).data, des.channel(5).data);
    mse = nrmse(des.channel(5).data, traces.channel(5).data, DT, TSTIM);
    %[ttl, err] = sprintf('Activation CA(t) of continuous attractor ( NRMSE = %g , cc = %g)', mse, cc);
    [ttl, err] = sprintf('Activation CA(t) of continuous attractor');
    title(ttl);
    h = legend('target', 'observed'); 
    set(h, 'fontsize', 9);
    fprintf('LoThresh = %g, HiThresh = %g\n', avgWt*(0.1+BASEVAL)/1e-9, avgWt*(0.3+BASEVAL)/1e-9);
    fprintf('Cont Arrractor, CC = %g\n', cc);
    
    
    %-------------------------------------------------------------------------
    % Plot switch readout
    %-------------------------------------------------------------------------
    axes('Position', [0.0752415 0.40998 0.850498 0.0669975]);
    lo = min([traces.channel(4).data des.channel(4).data des.channel(2).data]);
    hi = max([traces.channel(4).data des.channel(4).data des.channel(2).data]); 

    discreteVal = S.info(1).car_switch_val;
    discreteVal(discreteVal ~=0) = 1;
    timeHi = time(find(diff(discreteVal) ~=0)) + DT;
    if(mod(length(timeHi), 2) == 1)
        timeHi = [timeHi TSTIM];
    end 

    for iRect = 1: length(timeHi)/2
         h = rectangle('position', [timeHi(2*iRect -1) lo (timeHi(2*iRect) - timeHi(2*iRect-1)) (abs(lo)+hi-1)]);
         set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
         hold on;
    end;
    hold on;
    plot(time(1:end-1),  des.channel(2).data, 'color', col_r2, 'linewidth', 2, 'linestyle', '--');
    hold on;
    plot(time(1:end-1), traces.channel(4).data, 'color', obs_line, 'linewidth', 2);
    hold on;
    plot(time(1:end-1), des.channel(4).data, 'color', des_line, 'linewidth', 2);hold on;
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', [], 'tickdir', 'out');
    axis tight;
    h = legend('r_2(t)');
    set(h, 'fontsize', 9);
    control_val.swtch.cc_des_ob = corr_coef(traces.channel(4).data, des.channel(4).data);
    control_val.swtch.cc_r2_ob = corr_coef(traces.channel(3).data, des.channel(2).data);
    control_val.swtch.nrmse_des_ob = nrmse(des.channel(4).data, traces.channel(4).data, DT, TSTIM);
    control_val.swtch.nrmse_r2_ob = nrmse(traces.channel(3).data, traces.channel(4).data, DT, TSTIM);
 
    %[ttl, err] = sprintf('Switch of other readout depending on CA(t) ( NRMSE = %g , cc = %g)', ...
    %                     control_val.swtch.nrmse_des_ob, control_val.swtch.cc_des_ob);
    %[ttl, err] = sprintf('Switch of other readout depending on CA(t)');
    [ttl, err] = sprintf('Switch of second readout between r_2(t) and 0, depending on CA(t)');
    %block
    %[ttl, err] = sprintf('Switch between r_2(t) and 0, depending on current value of CA(t)');
    %block
    title(ttl);
    fprintf('Switch Readout, CC = %g\n',control_val.swtch.cc_des_ob);
    
    %-------------------------------------------------------------------------
    % Plot r1(t) - CA(t)
    %-------------------------------------------------------------------------
    axes('Position', [0.0721645 0.299572 0.850498 0.0669975]);
    plot(time(1:end-1), traces.channel(3).data, 'color', obs_line, 'linewidth', 2);
    hold on;
    plot(time(1:end-1), des.channel(3).data, 'color', des_line, 'linewidth', 2);
    set(gca, 'box', 'on', 'YAxisLocation', 'left');
    xlabel('time (s)');
    axis tight;
    control_val.cardiff.cc_des_ob = corr_coef(traces.channel(3).data, des.channel(3).data);
    control_val.cardiff.cc_car_ob = corr_coef(traces.channel(3).data, des.channel(5).data);
    control_val.cardiff.cc_r1_ob = corr_coef(traces.channel(3).data, des.channel(1).data);
    control_val.cardiff.nrmse_des_ob = nrmse(des.channel(3).data, traces.channel(3).data, DT, TSTIM);
    control_val.cardiff.nrmse_car_ob = nrmse(des.channel(5).data, traces.channel(3).data, DT, TSTIM);
    control_val.cardiff.nrmse_r1_ob = nrmse(des.channel(1).data, traces.channel(3).data, DT, TSTIM);
    %[ttl, err] = sprintf('Computation of r_1(t) - CA(t) ( NRMSE = %g , cc = %g)', ...
    %                      control_val.cardiff.nrmse_des_ob, control_val.cardiff.cc_des_ob);
    [ttl, err] = sprintf('Computation of r_1(t) - CA(t) by third readout');
    %block
    %[ttl, err] = sprintf('Computation of r_1(t) - CA(t)');
    fprintf('R1 - CA Readout, CC = %g\n',control_val.cardiff.cc_des_ob);

    title(ttl);  
    
    %-------------------------------------------------------------------------
    % Plot stimulus clamping results
    %-------------------------------------------------------------------------
    axes('Position', [0.08 0.0354691 0.290769 0.172769]);
    NEURONIDX = 120;
    for j = 1:10
        %[fname, err] = sprintf('../hh_neuron_switch/results/w/run_fixed%g.mat', j);
        [fname, err] = sprintf('../continuous_attractor/results_100/w/run_fixed%g.mat', j);
        load(fname);
        st = R{1}.channel(NEURONIDX).data;
        st(st<0.1) = [];
        line([st;st],(10-j)+[0.4; -0.4]*ones(1,length(st)),...
             'Color', 'k','Linewidth',1.5);
        axis([0.1 S.info(1).Tstim -2 12]);
    end
    xlabel('time (s)');
    ylabel('trial no.');
    title('Response variability to fixed stimulus');
    set(gca, 'box', 'on', 'ytick', [0 4 9], 'yticklabel', [1 5 10]);
    %-------------------------------------------------------------------------
    % Plot evidence gathering results
    %-------------------------------------------------------------------------
    axes('Position', [0.445385 0.0411899 0.363077 0.173913]);
    timeEvid = (0:2e-3:0.5);
    leg_arr = [];
    load('../evidence_gathering_hh_neuron/results/workspace.mat'); 
    p = get(nmc, 'pool');
    fbNeuronIdx = p(2).neuronIdx;
    avgWt = find_average_weights(nmc, fbNeuronIdx);
    for iEvid = 1 :8
        [fname, err] = sprintf('../evidence_gathering_hh_neuron/results/w/run%g.mat',iEvid);
        load(fname);
     
        des.channel(1).data = S.info(1).carval(1:end-1);   %ro1
     
    
        % car
        if(S.info(1).diff == 10)
            col = 'r';
        end;
        if(S.info(1).diff == 30)
            col = 'm';
        end
        if(S.info(1).diff == 50)
            col = 'g';
        end
        if(S.info(1).diff == 70)
            col = 'b';
        end;
        if(S.info(1).isUp ==1)
            h = plot(timeEvid(1:end-1), (avgWt * traces.channel(1).data)/1e-9, 'color', col, ...
                'linewidth', 2);
        else
            h = plot(timeEvid(1:end-1), (avgWt * traces.channel(1).data)/1e-9, 'color', col, ...
                'linewidth', 2, 'linestyle', '--');
        end;
        %if(i <= NVALIDATE/2)
            leg_arr = [leg_arr h];
        %end
        hold on;
        xlabel('time (s)');
        title('Integration of evidence by continuous attractor');
    end;
    axis tight;
    ylabel('nA');
    h = plot(0,0,'ow');
    leg_arr = [h leg_arr];
    h = plot(0,0,'ow');
    leg_arr = [h leg_arr];
    leg_arr = [leg_arr(1:2) leg_arr(6:-1:3) leg_arr(7:1:10)];
    %legend(leg_arr, 'r_1 -r_2 (Hz)', 'dummy', '10', '30', '50', '70', '-10', '-30', '-50', '-70', 1); 
    h = legend(leg_arr, 'r_1 -r_2  (Hz)', 'dummy', '70', '50', '30', '10', '-10 ', '-30 ', '-50 ', '-70 ', 1); 
    set(h, 'fontsize', 9);
    clear des traces;

    R = input('\n\nLabels (Enter - No | Anyotherkey - Yes)?');
    if(~isempty(R))
        axes('position', [0 0 1 1], 'visible', 'off');
        gtext('A', 'fontweight', 'bold', 'fontsize', 12);
        gtext('B', 'fontweight', 'bold', 'fontsize', 12);
        gtext('C', 'fontweight', 'bold', 'fontsize', 12);
        gtext('D', 'fontweight', 'bold', 'fontsize', 12);
        gtext('E', 'fontweight', 'bold', 'fontsize', 12);
        gtext('F', 'fontweight', 'bold', 'fontsize', 12);
        gtext('G', 'fontweight', 'bold', 'fontsize', 12);
        gtext('H', 'fontweight', 'bold', 'fontsize', 12);
        gtext('r_1 - r_2 (Hz)', 'fontsize', 10);
        anykey;
    end; 
end;
