addpath('../timer_attractor');
load_params;
load('../timer_attractor/data_dynamic/circuits/nmc.mat');
col_shade = [102 255 254]/255; 
time = (0:DT:TSTIM);
for i = 1:NVALIDATE
    clf
    [fname, e] = sprintf('../timer_attractor/results_dynamic/dual_run%g.mat', i);
    load(fname);
    subplot(6,1,1);
    % plot the inputs to the system
    for j = 1:NO_IP_CHANNELS + NO_NOISE_CHANNELS
        st = S.channel(j).data;
        col(j<=NO_IP_CHANNELS) = 'r';
        col(j>NO_IP_CHANNELS) = 'k';
        line([st;st],j+[0.3; -0.3]*ones(1,length(st)),...
             'Color', col,'Linewidth',1.5);
        axis([0 S.info(1).Tstim (-2) (NO_IP_CHANNELS+NO_NOISE_CHANNELS+2)]);
    end;
    %title('External input consisting of a cue (red) and noise (black)');
    title('External input consisting of a cue (gray) and noise (black)');
    set(gca, 'xticklabel', [], 'yticklabel', [], ...
        'YAxisLocation', 'left', 'tickdir', 'out', 'box', 'on');
 

    subplot(6,1,2);

    p = get(nmc, 'pool');
    p = p(5);
    neuronIdx = p.neuronIdx;

    % the neurons that receive external input
    r1neuronIdx = neuronIdx(1:125);
    idxR1 = randperm(125);
    idxR1 = idxR1(1:20);
    idxR1 = r1neuronIdx(idxR1);
 
    % the neurons that receive no input
    noipneuronIdx = neuronIdx(126:275);
    idxnoIP = randperm(150);
    idxnoIP = idxnoIP(1:25);
    idxnoIP = noipneuronIdx(idxnoIP);
 
    % the neurons that receive r2
    fbneuronIdx = neuronIdx(276:600);
    idxFB = randperm(325);
    idxFB = idxFB(1:55);
    idxFB = fbneuronIdx(idxFB);
 
 
    idx.neuronIdx = [idxR1 idxnoIP idxFB];
 
    % now make the corresponding channel idx from the response
    for iIdx = 1:length(idx.neuronIdx)
        idxCh = find(neuronIdx == idx.neuronIdx(iIdx));
        idx.chIdx(iIdx) = idxCh;
    end 
    make_timer_rasters;
    axis tight;
    xlim([0 TSTIM]);
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', [], 'tickdir', 'out');
    title('Circuit response (shown for 100 out of 600 neurons)'); 

    subplot(6,1,3);
    p = get(nmc, 'pool');
    fbNeuronIdx = p(3).neuronIdx;
    avgWt = find_average_weights(nmc, fbNeuronIdx);
    % plot the closed loop performance of the decay timer
    desSignal = (S.info(1).timer_ro1val(1:end-1) * avgWt)/64.1593e-9;
    obsSignal = (traces.channel(1).data * avgWt)/64.1593e-9;
    lo = min([desSignal obsSignal]);
    hi = max([desSignal obsSignal]);                        
    %h = rectangle('position', [TSTART lo TRESET (abs(lo)+hi)]); set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
    %h = area([TSTART (TSTART+TRESET1)], [(abs(lo)+hi) (abs(lo)+hi)]);

    %h = rectangle('Position', [TSTART (lo+0.01) TRESET1 (abs(lo)+hi -0.02)]);
    %set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]); 
    hold on;
    plot(time(1:end-1), (avgWt * S.info(1).timer_ro1val(1:end-1))/64.1593e-9, 'k', 'linewidth',2);
    hold on;
    plot(time(1:end-1), (avgWt * traces.channel(1).data)/64.1593e-9, 'r', 'linewidth', 2);
    set(gca, 'xticklabel', [], 'tickdir', 'out', 'box', 'on');
    axis tight;
    ylabel('nA'); 
    title('Time course of a continuous attractor with decay time of 400 msec');
    legend('target', 'observed', 1);
    
    subplot(6,1,4);
    p = get(nmc, 'pool');
    fbNeuronIdx = p(4).neuronIdx;
    avgWt = find_average_weights(nmc, fbNeuronIdx);
    % plot the closed loop performance of the decay timer
    desSignal = (S.info(1).timer_ro2val(1:end-1) * avgWt)/64.1593e-9;
    obsSignal = (traces.channel(2).data * avgWt)/64.1593e-9;
    lo = min([desSignal obsSignal]);
    hi = max([desSignal obsSignal]);             

    %h = rectangle('position', [TSTART lo TRESET (abs(lo)+hi)]); set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
    %h = area([TSTART (TSTART+TRESET2)], [(abs(lo)+hi) (abs(lo)+hi)]);
    %h = rectangle('Position', [TSTART (lo+0.01) TRESET2 (abs(lo)+hi-0.02)]);
    %set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]); 
    hold on;
    plot(time(1:end-1), (avgWt * traces.channel(2).data)/64.1593e-9, 'r', 'linewidth', 2);
    hold on;
    plot(time(1:end-1), (avgWt * S.info(1).timer_ro2val(1:end-1))/64.1593e-9, 'k', 'linewidth',2);
    set(gca, 'xticklabel', [], 'tickdir', 'out', 'box', 'on');
    axis tight;
    ylabel('nA'); 
    title('Time course of a continuous attractor with decay time of 600 msec');
    %legend('observed', 'target', 1);


    [fname, e] = sprintf('../timer_attractor/results_dynamic/gain_run%g.mat', i);
    load(fname);

    subplot(6,1,5);
    % plot the circuit response due to gain timer
    make_timer_rasters;
    axis tight;
    xlim([0 TSTIM]);
    %plot_channels(R{1}.channel,R{1}.Tsim);
    set(gca, 'box', 'on', 'YAxisLocation', 'left', 'XTickLabel', [], 'tickdir', 'out');
    title('Response of the same circuit with a different high-dimensional attractor'); 
 

    if 1
    subplot(6,1,6);
    p = get(nmc, 'pool');
    fbNeuronIdx = p(3).neuronIdx;
    avgWt = find_average_weights(nmc, fbNeuronIdx);
    % plot the closed loop performance of the decay timer
    desSignal = (S.info(1).timer_ro1val(1:end-1) * avgWt)/64.1593e-9;
    obsSignal = (traces.channel(1).data * avgWt)/64.1593e-9;
    lo = min([desSignal obsSignal]);
    hi = max([desSignal obsSignal]); 
    %h = rectangle('position', [TSTART lo TRESET (abs(lo)+hi)]); set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]);
    %h = area([TSTART (TSTART+TRESET)], [(abs(lo)+hi) (abs(lo)+hi)]);
    %h = rectangle('Position', [TSTART lo TRESET (abs(lo)+hi)]);
    %set(h, 'Facecolor', col_shade, 'Edgecolor', [1 1 1]); 
    hold on;
    plot(time(1:end-1), (avgWt * traces.channel(1).data)/64.1593e-9, 'r', 'linewidth', 2);
    hold on;
    plot(time(1:end-1), (avgWt * S.info(1).timer_ro1val(1:end-1))/64.1593e-9, 'k', 'linewidth',2);
    %legend('observed', 'target', 1);
    set(gca, 'tickdir', 'out', 'box', 'on');
    xlabel('time (s)');
    ylabel('nA'); 
    axis tight;
    title('Time course of continuous attractor trained to reach plateau after 600 msec');
    end


    ur = input('\n\nLabels (Enter - No | Anyotherkey - Yes)?');
    if(~isempty(ur))
        gtext('A', 'fontweight', 'bold', 'fontsize', 12);
        gtext('B', 'fontweight', 'bold', 'fontsize', 12);
        gtext('C', 'fontweight', 'bold', 'fontsize', 12);
        gtext('D', 'fontweight', 'bold', 'fontsize', 12);
        gtext('E', 'fontweight', 'bold', 'fontsize', 12);
        gtext('F', 'fontweight', 'bold', 'fontsize', 12);
        anykey;
    end 
end;

