%-------------------------------------------------------------------------
% Desc - Plots the continuous attractor readout, and circuit response
%-------------------------------------------------------------------------
  clear all classes;
  close all;

  addpath('../hh_new0');
  load_params;
  time = DT:DT:TSTIM;
  mfr100 = [];
  mfr20 = [];
  plot = 0;
  for i = 1:NVALIDATE
      [fn, e] = sprintf('../hh_new0/results/w/run%g.mat', i);
      load(fn);
      clf;
      if(plot ==1)
      axes('position', [0.0798    0.8609    0.8539    0.0851]);
      plot(time, S.info(1).ro1val(1:end-1));
      hold on;
      plot(time, S.info(1).rate2val(1:end-1), '-.');
      legend('r_1(t)', 'r2_t');
      
      axes('position', [0.0731    0.7241    0.8539    0.0851]);
      plot(time, S.info(1).carval(1:end-1)+BASEVAL, 'k');
      hold on;
      plot(time, traces.channel(5).data, 'r');
      cc = corr_coef(S.info(1).carval(1:end-1)+BASEVAL, traces.channel(5).data);
      [t,e] = sprintf('cc = %g', cc);
      title(t);
      hold on;
      
      axes('position', [0.0812    0.0793    0.8539    0.5828]);
      plot_channels(R{1}.channel(:), TSTIM);
      end
      mfr100(i) = length([R{1}.channel(:).data])/(600*TSTIM);

      [fn, e] = sprintf('../hh_no_fb/results/w/run%g.mat', i);
      load(fn);
      mfr20(i) = length([R{1}.channel(:).data])/(600*TSTIM);
     
      %anykey;
  end

