f = 1000*(0:256)/512;
FLO = 0;
idx = find(f <FLO);
nDataLost = length(idx);
f(1:nDataLost) = [];

%subplot(5,1,4);
%% plot the data for the power spectrum from the FB layer in UP
%% and down state
%
%% find the response in the FB layer
Resp = R{2}; % R{2} holds the membrane potential of neurons
Resp.channel = Resp.channel(126:225);
%
%% find the index of DOWN and UP states.
find_states;
idx_lo = find(state == 0);
idx_hi = find(state == 1);
idx_hi(idx_hi>200) = [];
idx_lo(idx_lo>200) = [];
keyboard;
%
%% now loop through all the channels
%nNeurons = length(Resp.channel);
%power_lo = [];
%power_hi = [];
%for i = 1: nNeurons
%    datalo = Resp.channel(i).data(idx_lo);
%    datahi = Resp.channel(i).data(idx_hi);
%    pslo = (fft(datalo, 512) .* conj(fft(datalo, 512)))/512;
%    pslo(1:nDataLost) = [];
%    pshi = (fft(datahi, 512) .* conj(fft(datahi, 512)))/512;
%    pshi(1:nDataLost) = [];
%    power_lo = vertcat(power_lo, pslo);
%    power_hi = vertcat(power_hi, pshi);
%end;
%avgPowLo = mean(power_lo);
%avgPowLo = avgPowLo(1:length(f));
%avgPowHi = mean(power_hi);
%avgPowHi = avgPowHi(1:length(f));
%stdPowLo = std(power_lo)./sqrt(nNeurons);
%stdPowLo = stdPowLo(1:length(f));
%stdPowHi = std(power_hi)./sqrt(nNeurons);
%stdPowHi = stdPowHi(1:length(f));
%
%
%%plot(f, avgPowLo, 'b');hold on;
%h1 = errorbar(f, avgPowLo, stdPowLo, 'b');hold on;
%
%%plot(f, avgPowHi, 'r');
%h2 = errorbar(f, avgPowHi, stdPowHi, 'r');
%legend([h1(1) h2(1)], 'DOWN', 'UP');
%set(gca, 'xticklabel', []);

axes('Position', [0.125215 0.138427 0.775 0.063232]);

% plot the data for the power spectrum from the entire circuit in UP
% and down state

% find the response in the FB layer
Resp = R{2}; % R{2} holds the membrane potential of neurons

% now loop through all the channels
nNeurons = length(Resp.channel);
power_lo = [];
power_hi = [];
for i = 1: nNeurons
    datalo = Resp.channel(i).data(idx_lo);
    datahi = Resp.channel(i).data(idx_hi);
    pslo = (fft(datalo, 512) .* conj(fft(datalo, 512)))/512;
    pslo(1:nDataLost) = [];
    pshi = (fft(datahi, 512) .* conj(fft(datahi, 512)))/512;
    pshi(1:nDataLost) = [];
    power_lo = vertcat(power_lo, pslo);
    power_hi = vertcat(power_hi, pshi);
end;
avgPowLo = mean(power_lo);
avgPowLo = avgPowLo(1:length(f));
avgPowHi = mean(power_hi);
avgPowHi = avgPowHi(1:length(f));
stdPowLo = std(power_lo);%./sqrt(nNeurons);
stdPowLo = stdPowLo(1:length(f));
stdPowHi = std(power_hi);%./sqrt(nNeurons);
stdPowHi = stdPowHi(1:length(f));
%h1 = errorbar(f(2:end), avgPowLo(2:end), stdPowLo(2:end), 'b');hold on;
%h2 = errorbar(f(2:end), avgPowHi(2:end), stdPowHi(2:end), 'r');
h2 = loglog(f, avgPowHi, 'r');hold on;
h1 = loglog(f, avgPowLo, 'b');
h = legend([h2(1) h1(1)] , 'attractor on', 'attractor off');
set(h, 'fontsize', 9);
title('Shift in power spectrum of membrane potential');
xlabel('frequency (Hz)');
axis tight;
