%-------------------------------------------------------------------------
% Desc - This part of the code performs the closed loop validation process.
%        First it converts the open loop readout to a closed loop readout
%        and then perform the simulation in a closed loop with new unseen 
%        inputs for validation.
%
%        (c), 2005, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------
clear all classes;
close all;
load_params;
time = (0:DT:TSTIM);
plot_labels = {'rate of channels 1-8' 'readout 1 - continuous attractor' 'switch based on car' 'car'};

for i = 1 :NVALIDATE
    [fname, err] = sprintf('./results/0.9_w/run%g.mat', i);
    load(fname);
    % calculate the desired values.
    des.channel(1).data = S.info(1).ro1val(1:end-1);   %ro1
    des.channel(2).data = S.info(1).ro2val(1:end-1);   %ro2
    des.channel(3).data = S.info(1).car_switch_val(1:end-1);   %car
    des.channel(4).data = S.info(1).carval(1:end-1);   %car
    
    % Now plot them
    figure;	
    col = 'r';

    % the plot which shows the rate at which the external inputs are drawn
    subplot(6,1,1);
    plot(time, S.info(1).r1, 'r', 'linewidth',2); hold on;
    plot(time, S.info(1).r2+100, 'b', 'linewidth',2); 
    xlabel('Rate at which the external inputs are drawn');

    % the actual external inputs
    subplot(6,1,2);
    for j = 1:NO_IP_CHANNELS
        if(j>8), col = 'b'; end;
        st = S.channel(j).data;
        line([st;st],(NO_IP_CHANNELS-j)+[0.3; -0.3]*ones(1,length(st)),...
             'Color',col,'Linewidth',1.5);
        axis([0 S.info(1).Tstim (-2) (NO_IP_CHANNELS+1)]);
    end;
    xlabel('The actual external inputs');

   % the performance of the three readouts
   for k = 1:4
        subplot(6,1,k+2);
        plot(time(1:end-1), traces.channel(k).data, 'r--', 'linewidth', 2);
        hold on;
        plot(time(1:end-1), des.channel(k).data, 'k', 'linewidth', 2);
        cc = corr_coef(traces.channel(k).data, des.channel(k).data);
        [ttl, err] = sprintf('%s, cc = %g', plot_labels{k}, cc);
        xlabel(ttl);
    end;
    anykey;
end;
