%-------------------------------------------------------------------------
% Desc - This part of the code performs the closed loop validation process.
%        First it converts the open loop readout to a closed loop readout
%        and then perform the simulation in a closed loop with new unseen 
%        inputs for validation.
%
%        (c), 2005, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------

fprintf('\n--------------------------------------------------------');
fprintf('\n\nNow starting the closed loop validation  process for %s\n\n', RESULT_PATH);
fprintf('--------------------------------------------------------\n');

%-------------------------------------------------------------------------
% Part I - Construct the transformed liquid
%-------------------------------------------------------------------------
[nmc, roIdx1] = transform_readout(nmc, trained_readouts{1});

% find the Teacher Feedback Neuron
pools = get(nmc, 'pool');
poolinp = pools(2);
teacher_fb_neuron = poolinp.neuronIdx;

% Create feedback connections
csim('connect', teacher_fb_neuron(1), roIdx1);

% Switch feedback on
csim('set', teacher_fb_neuron(1), 'feedback', 1);
%csim('set', teacher_fb_neuron(1), 'feedback_delay', 10);

% add recorder to record the output of our transformed readouts.
rec = csim('create', 'Recorder');
csim('set', rec, 'dt', DT);
csim('connect', rec, roIdx1, 'output');


%-------------------------------------------------------------------------
% Part II - Perform Validation
%-------------------------------------------------------------------------
fprintf('\n--------------------------------------------------------');
fprintf('\n\nRunning %i simulations in closed loop\n\n', NVALIDATE);
fprintf('--------------------------------------------------------\n');
for i = 1 :NVALIDATE
    if(mod(i, 10) == 0)
        fprintf('\n\nClosed loop validation run number %g\n\n', i);
    end;
    S = val_stimuli(i);
    [R] = wo_delay_validate(nmc, trained_readouts, S);

    traces = csim('get', rec, 'traces');

     % now save the data
    [fname, err] = sprintf('%s/run%g.mat', RESULT_PATH, i);
    save(fname, 'S', 'traces', 'R', 'DT', 'TSTIM')       

end;
