%--------------------------------------------------------------------------
% Desc - Creates the liquid for the simulation
%
% Also See - load_params.m
%
%            (c), 2004, Prashant Joshi ( joshi@igi.tugraz.at )
%--------------------------------------------------------------------------
% create the input neurons
% Create an input pool of  spiking input neurons.
[nmc, pin] = add(nmc, 'Pool', 'origin', ORIG_POOL_IP, 'size', ...
                           [1 2 NO_IP_CHANNELS/2], 'type', ...
                           NTYPE_IP, 'frac_EXC', 1.0);

% create the pool of teacher feedback neurons
[nmc, pfb] = add(nmc, 'Pool', 'origin', ORIG_POOL_FB, 'size', ...
                           [1 1 NO_READOUTS], 'type', ...
                           NTYPE_TFB, 'frac_EXC', 1.0);
                 
% Create the liquid
[nmc, poolnmc] = add(nmc, 'Pool', 'origin', ORIG_POOL_NMC, 'size', CIRCUIT_SIZE, ...
                    'type' , 'CbHHOuNeuron',...
                    'frac_EXC', 0.8, ...
                    'Neuron.Rm', Rm,...
                    'Neuron.Cm', Cm,...
                    'Neuron.Trefract', 3e-3,...
                    'Neuron.Vthresh', -30e-3,...
                    'Neuron.Vresting', Vresting,...
                    'Neuron.Ee', Ee,...
                    'Neuron.Ei', Ei,...
                    'Neuron.ge0', ge0,...
                    'Neuron.sig_e', sig_e,...
                    'Neuron.tau_e', tau_e,...
                    'Neuron.gi0', gi0,...
                    'Neuron.sig_i', sig_i,...
                    'Neuron.tau_i', tau_i); 

%[nmc, poolnmc] = add(nmc, 'Pool', 'origin', ORIG_POOL_NMC, 'size', CIRCUIT_SIZE, ...
%                    'frac_EXC', 0.8, ...
%		    'type', 'LifNeuron', 'Neuron.Vthresh', 0.015, ...
%                     'Neuron.Vreset', [0 0], 'Neuron.Vinit', [0 0], ...
%                     'Neuron.Iinject', [13.5e-9 14.5e-9], 'Neuron.Trefract', 0.003, ...
%                     'Neuron.Inoise', [4e-9 5e-9]);

% Connect the  input neurons to the liquid
% The first two neurons simulate the start and stop burst
[nmc, cip] = add(nmc, 'Conn', 'src', pin, 'dest', poolnmc,...%[6 0 4; 10 4 11], ...
                             'type', STYPE_IP, 'Cscale', csip2liq, ...
                             'Wscale', wsip2liq, 'rescale', 0, 'lambda', lamip2liq);
[nmc, cfb] = add(nmc, 'Conn', 'src', pfb, 'dest', poolnmc,...%[6 0 12; 10 4 15], ...
                             'type', STYPE_TFB, 'Cscale', csfb, ...
                             'Wscale', wsfb, 'rescale', 0, 'lambda', lamfb);         
                    

% make recurrent connections in the liquid
[nmc, cr] = add(nmc, 'Conn', 'dest', poolnmc, 'src', poolnmc,...
                         'Cscale', csliq, 'Wscale', wsliq, 'lambda', lamliq,...
		                 'type', STYPE_CIRCUIT);

c  = get(nmc, 'conn');
Wsum = c(1).Wsum;
Wsum(3) = Wsum(3)*4;
c(1).Wsum = Wsum;
c(2).Wsum = Wsum;
c(3).Wsum = Wsum;
set(nmc, 'conn', c);
csim('export');


% now add recorders
nmc = record(nmc, 'Pool', poolnmc, 'Field', 'spikes','dt', DT);
