%--------------------------------------------------------------------------
% Desc - This file defines the parameters for the simulation
%
%            (c), 2004, Prashant Joshi (joshi@igi.tugraz.at)
%--------------------------------------------------------------------------
global NO_FB_CHANNELS NO_IP_CHANNELS TSTIM DT KERNEL_SIZE NKERNELS SET DIFF_RATE
%--------------------------------------------------------------------------
% Simulation Parameters
%--------------------------------------------------------------------------

% the time step of simulation in seconds
DT = 2e-3;

% the total time of simulation in seconds
TSTIM = 500e-3;

% the higher the value the more the plots that will be generated
PLOTTING_LEVEL = 1;

% number of training iterations
NTRAIN = 150;

% number of testing iterations
NTEST = 30;

% number of validation runs
NVALIDATE = 8;

% The size of kernel window for the open loop readouts
KERNEL_SIZE = 30e-3;

% The number of gaussian kernels used in perturbation experiment.
NKERNELS = 10;

DIFF_RATE = [10 30 50 70];

%-------------------------------------------------------------------------
% Parameters from Stefan's model
%-------------------------------------------------------------------------
noise = 1;
A = 34636e-12; % [m]
 
gl = 0.045e-3/1e-4*A; % [S]
Rm = 1/gl;
Cm = 1e-6/1e-4*A;
  
Vresting = -80e-3;         % Volt
   
%nn_scaling = 25/prod(layer_base);
   
ge0 = 0.012e-6;   % parameters for Ornstein-Uhlenbeck noise
% sig_e = 0.012e-6;
sig_e = 0.003e-6*(noise~=0);
tau_e = 2.7e-3;
    
gi0 = 0.057e-6;
% sig_i = 0.0264e-6;
sig_i = 0.0066e-6*(noise~=0);
tau_i = 10.5e-3;
      
Ee = 0e-3;
Ei = -75e-3; 
      

%--------------------------------------------------------------------------
% Liquid parameters
%--------------------------------------------------------------------------

% circuit type
nmc = neural_microcircuit;

% number of layers
NO_LAYERS = 3;

% neuron type
NTYPE_CIRCUIT = 'LifNeuron';
NTYPE_IP = 'SpikingInputNeuron';
NTYPE_TFB = 'AnalogFeedbackNeuron';

% synapse types
STYPE_IP = 'StaticSpikingSynapse';
STYPE_TFB = 'StaticAnalogSynapse';
STYPE_CIRCUIT ='DynamicSpikingSynapse';

% circuit size
CIRCUIT_SIZE = [5 5 12];

% number of input channels (excluding feedback)
NO_IP_CHANNELS = 16;

% number of readouts
NO_READOUTS = 1;
NO_FB_CHANNELS = NO_READOUTS;

% define the origin of input pool, liquid and the linear readout
ORIG_POOL_NMC = [6 0 4];
ORIG_POOL_IP  = [1 1 6];
ORIG_POOL_FB  = [2 1 9];

% set the connection parameters

% for connections from ip --> liq
wsip2liq  = 0.05;
csip2liq  = 10;
lamip2liq = 5;

% for connection that simulate teacher feedback
wsfb   = 0.04;
csfb = 10;
lamfb  = 5.0;

% for recurrent connections liq --> liq
wsliq  = 1;
csliq  = 1;
lamliq = 3;
