%--------------------------------------------------------------------------
% Desc - This files launches the experiment with the continuous spiking
%             readouts.
%
%            (c), 2004, Prashant Joshi (joshi@igi.tugraz.at)
%--------------------------------------------------------------------------
clear all classes;
close all;


%-------------------------------------------------------------------------
% Load the simulation parameters and create the liquid
%-------------------------------------------------------------------------
load_params;
make_liquid;


%-------------------------------------------------------------------------
% Create the stimulus object
%-------------------------------------------------------------------------
TrainDist = evidence_gathering_stimulus;
S = generate(TrainDist, 50, 1);
if(PLOTTING_LEVEL >0)
    figure(1);
    plot(TrainDist, S);
    drawnow;
    figure(2);
    plot_circuit_resp;
    drawnow;
end
anykey;
%-------------------------------------------------------------------------
% PART 1 - TRAINING OF A LINEAR READOUT
%-------------------------------------------------------------------------

% collect the stimulus and response pairs for training and testing
[train_response,train_stimuli] = collect_sr_data_evid(nmc, ...
                                                     TrainDist,...
                                                     NTRAIN, ...
                                                     TSTIM);
[test_response,test_stimuli] = collect_sr_data_evid(nmc, ...
                                                     TrainDist,...
                                                     NTEST, ...
                                                     TSTIM);

ltrain_val  = response2states(train_response,[], ...
                             [0:DT:TSTIM]);%, ...
                             %{ 'spikes2alpha' 0.05 });
ltest_val  = response2states(test_response,[], ...
                             [0:DT:TSTIM]);%, ...
                             %{ 'spikes2alpha' 0.05 });

% add the readouts
readout{1} = external_readout('targetFunction',car,...
    'description','continuous attractor readout');

[trained_readouts] = train_readouts(readout,ltrain_val, train_stimuli,...
                                                        ltest_val, test_stimuli);
% plot the output of the trained readouts of the test data
%VERBOSE_LEVEL  = 1;
%figure;
 
%best_example = plot_readouts(trained_readouts,test_response,test_stimuli,...
%                             { 'response2states' [0:DT:TSTIM] {'spikes2exp' 0.03}} );  

% generate a validation set with NVALIDATE inputs.
fprintf('\n\n***\ngenerating validation data\n***\n\n');
isUp = 1;
for i = 1:NVALIDATE
    if(i > NVALIDATE/2)
        isUp = 0;
    end
    val_stimuli(i) = generate(TrainDist, DIFF_RATE(mod((i-1), length(DIFF_RATE))+1), isUp);
end
% save the important variables
save('./results/workspace.mat', 'nmc', 'trained_readouts', 'TrainDist', 'val_stimuli');

%-------------------------------------------------------------------------
% run in closed loop setup with real weights
%-------------------------------------------------------------------------
load('./results/workspace.mat');
RESULT_PATH = './results/w';
online_validation;


