function I=generate(gi, diffRate, isUp)
%-------------------------------------------------------------------------
% Desc - This file generates the 16 input channels of which 8 are drawn with
%        one rate and 8 with another rate, both of which have been drawn randomly.
%        Also produces one channel of TFB stimuli.
%
%        (c), 2005, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------

global DT TSTIM NO_IP_CHANNELS NO_FB_CHANNELS DIFF_RATE

t=0:DT:TSTIM;
lent = length(t);

lower_rate_range = [60 50 40 30];
upper_rate_range = [70 80 90 100];
fixed_rate_range = [65];

idx = find(DIFF_RATE == diffRate);
if(isUp == 0)
    rate1 = lower_rate_range(idx) * ones(1, lent);
    rate2 = upper_rate_range(idx) * ones(1, lent);
else
    rate1 = upper_rate_range(idx) * ones(1, lent);
    rate2 = lower_rate_range(idx) * ones(1, lent);
end
idxFixed = find(t <= 0.1);
rate1(idxFixed) = fixed_rate_range;
rate2(idxFixed) = fixed_rate_range;
 
bg1 = rate2spikes(rate1,  DT, NO_IP_CHANNELS/2, TSTIM);
bg2 = rate2spikes(rate2, DT, NO_IP_CHANNELS/2, TSTIM);

for i = 1:NO_IP_CHANNELS
    if(i<=NO_IP_CHANNELS/2)
        I.channel(i).data = bg1{i};
    else
        I.channel(i).data = bg2{i-8};
    end
    I.channel(i).spiking = 1;
    I.channel(i).dt = -1;
end

op = values_for_car(I);
I.channel(17).data = add_noise([0 op(1:end-1)]);
I.channel(17).spiking = 0;
I.channel(17).dt = DT;

% --- Add some information to the stimulus ----
I.info(1).Tstim = TSTIM;
I.info(1).r1 = rate1;
I.info(1).r2 = rate2;
I.info(1).carval = op;
I.info(1).isUp = isUp;
I.info(1).diff = diffRate;
