function r = cumrate(spiketrains, twindow, ctime)

%------------------------------------------------------------------------
% Desc - This function calculates the running sum of rates of two spike
%        trains in a time window of twindow ms.
%
%        (c), 2004, Prashant Joshi ( joshi@igi.tugraz.at )
%-------------------------------------------------------------------------

st1 = spiketrains{1};
st2 = spiketrains{2};

ltime = ctime - twindow;

nspikes1 = find(st1>= ltime & st1 <=ctime);
nspikes2 = find(st2>= ltime & st2 <=ctime);

r = (nspikes1 + nspikes2)/twindow;

