%-------------------------------------------------------------------------
% Desc - This file trains the linear readouts after the partial attractors
%        have been calibrated. The training is done when the circuit is 
%        receiving actual feedback.
%-------------------------------------------------------------------------

run_closed_loop;

fprintf('generating %g samples of closed loop data\n', NTRAIN);

for i = 1:NTRAIN
   reset(nmc);
   S = train_stimuli(i);
   R = simulate(nmc, TSTIM, S);
   for j = 1:8
       S.channel(NO_IP_CHANNELS+j).data = R{4}.channel(j).data;
   end
   closed_loop_stimuli(i) = S;
   closed_loop_response(i) = R{1};
end;

ltrain_val  = response2states(closed_loop_response,[], ...
                             [0:DT:TSTIM]);
                             %{ 'spikes2alpha' 0.05 });
ltest_val  = response2states(closed_loop_response,[], ...
                             [0:DT:TSTIM]);


% readouts for testing
clear readout;
readout{1} = external_readout('targetFunction',roch1,...
                      'description','rate of channel 17-24', ...
                      'algorithm', linear_regression);
readout{2} = external_readout('targetFunction',roch2,...
                      'description','rate of channel 25-32',...
                      'algorithm', linear_regression);
readout{3} = external_readout('targetFunction',rofb,...
                      'description','rate of feedback channels',...
                      'algorithm', linear_regression);
readout{4} = external_readout('targetFunction',roprod,...
                      'description','Computes Product',...
                      'algorithm', linear_regression);
readout{5} = external_readout('targetFunction',roampl,...
                      'description','Amplification',...
                      'algorithm', linear_regression);
readout{6} = external_readout('targetFunction',roattn,...
                      'description','Attention Switching',...
                      'algorithm', linear_regression);

[trained_readouts] = train_readouts(readout,ltrain_val,closed_loop_stimuli,...
                                                        ltest_val, closed_loop_stimuli);

