function r = sumofrates(S, kernelsize, dt, Tstim)

nspkTrains = length(S.channel);

t = (0:dt:Tstim);
lent = length(t);
nval = 1;

for i = 1:lent
    if(t(i) <= kernelsize)
        nval = t(i);
    else
        nval = kernelsize;
    end;
    %now iterate through the spike trains
    nspk = 0;
    for j = 1:nspkTrains
        nspk = nspk + length(find(S.channel(j).data >(t(i) - nval) & S.channel(j).data<=t(i)));
    end;
    if(nspk==0)
        r(i) = 0;
    else
        r(i) = (nspk/nval);
    end;
end;

