%--------------------------------------------------------------------------
% Desc - Runs the simulation in open loop.
%
% To run in the open loop, turn ON the teacher feedback and turn OFF the
% feedback from spiking readouts
%--------------------------------------------------------------------------
	pool = get(nmc, 'pool');
	pool = pool(8);
	spiking_readout_idx = pool.neuronIdx;
	
	% set connections from the spiking readouts to the liquid (actul feedback) to zero
        pre_syn = []; post_syn = [];
	for idx_open_loop = 1:NO_READOUTS
	    [pre_syn, post_syn] = csim('get', spiking_readout_idx(idx_open_loop), 'connections');
            cnt10 = length(post_syn);
	    for idx10 = 1:cnt10
	        csim('set', post_syn(idx10), 'W', 0);
	    end
	end
	
	% connect the neurons from the liquid to the spiking readouts
	pool = get(nmc, 'pool');
	pool = pool(5);
	teacher_fb_neuron_idx = pool.neuronIdx;
        pre_syn = []; post_syn = [];
	for idx_fb = 1:NO_READOUTS
	    [pre_syn, post_syn] = csim('get', teacher_fb_neuron_idx(idx_fb), 'connections');
            cnt11 = length(post_syn);
	    for idx11 = 1 : cnt11
	        csim('set', post_syn(idx11), 'W', Wtfb.readout(idx_fb).weights(idx11));
	    end
	end
