%--------------------------------------------------------------------------
% Desc - Runs the simulation in closed loop.
%
% To run in the closed loop, turn OFF the teacher feedback and turn ON the
% feedback from spiking readouts
%--------------------------------------------------------------------------
pool = get(nmc, 'pool');
pool = pool(8);
spiking_readout_idx = pool.neuronIdx;

% connect the neurons from the liquid to the spiking readouts

pre_syn = []; post_syn = [];
for idx_close_loop = 1:NO_READOUTS
    [pre_syn, post_syn] = csim('get', spiking_readout_idx(idx_close_loop), 'connections');
    cnt8 = length(post_syn);
    for idx8 = 1:cnt8
        csim('set', post_syn(idx8), 'W', Wsfb.readout(idx_close_loop).weights(idx8));
    end
end

% connect the spiking readouts to the liquid (actul feedback)
pool = get(nmc, 'pool');
pool = pool(5);
teacher_fb_neuron_idx = pool.neuronIdx;
pre_syn = []; post_syn = [];
for idx_loop = 1:NO_READOUTS
    [pre_syn, post_syn] = csim('get', teacher_fb_neuron_idx(idx_loop), 'connections');
    cnt9 = length(post_syn);
    for idx9 = 1 : cnt9
        csim('set', post_syn(idx9), 'W', 0);
    end
end
