function perf = performance_of_spiking_readouts(S,R)

global DT TSTIM NO_IP_CHANNELS NO_READOUTS KERNEL_SIZE

time = (0:DT:TSTIM);

des_val = S.info(1).data;
des_val(des_val~=0) = 1;

for i = 1:NO_READOUTS
    Resp.channel(i).data = R{4}.channel(i).data;
    res_tmp.channel(1).data = Resp.channel(i).data;
    obs_val = sumofrates(res_tmp, KERNEL_SIZE, DT, TSTIM);
    obs_val = lpf(obs_val, KERNEL_SIZE/DT);
    obs_val(obs_val~=0) = 1;
    perf(i) = 1 - length(find([des_val - obs_val]~=0))/length(obs_val);
end;

obs_val = sumofrates(Resp, KERNEL_SIZE, DT, TSTIM);
obs_val = lpf(obs_val, KERNEL_SIZE/DT);
obs_val(obs_val~=0) = 1;
perf(length(perf)+1) = 1 - length(find([des_val - obs_val]~=0))/length(obs_val);
%plot(time, des_val, 'k', 'linewidth', 2);hold on; plot(time, obs_val, 'r', 'linewidth', 2);
%axis([0 TSTIM 0 2]);

